import { _decorator, Component, Node, AnimationComponent, AnimationState } from 'cc';
const { ccclass, property } = _decorator;

@ccclass('CrossFadeAnimation')
export class CrossFadeAnimation extends Component {

    start() {
        let animation = this.getComponent(AnimationComponent)!;
        animation.on(AnimationComponent.EventType.FINISHED, (type: any, state: AnimationState) => {
            if (state.clip.name === 'ShrinkToStand') {
                animation.crossFade('StandIdle', 1);
            }
        })
        animation.play('ShrinkToStand');
    }

}
