// tv全局数据

window.tv = module.exports = {
    _TAG: 'TV',
    _isInit: true,

    customEvent: new cc.EventTarget(),
    curStatus: '',//当前状态
    // 状态列表
    status: {
        start: 'start',
        choose: 'choose',
    },

    init() {
        if (this._isInit) {
            this._isInit = false;
            this.curStatus = this.status.start;
            for (let i in this.status) {
                this[this.status[i] + 'List'] = [];
                this[this.status[i] + 'Count'] = 0;
            }
        }
    },

    getIndex(status) {
        for (let i in this.status) {
            if (this.status[i] === status) {
                return i;
            }
        }
        return null;
    },

    emit(node) {
        if (!node) {
            cc.warn(this._TAG + ' emit param error');
            return;
        }
        let pos = this.convertPos(node);
        this.customEvent.emit('cursor', { pos });
    },

    convertPos(node) {
        if (!node) {
            cc.warn(this._TAG + ' convertPos param error');
            return;
        }
        return cc.pSub(node.parent.convertToWorldSpaceAR(node.position), cc.p(cc.winSize.width / 2, cc.winSize.height / 2));
    },

    reset(status) {
        if (!status || typeof status === 'undefined') {
            return;
        }
        this.curStatus = status;
        this[status + 'Count'] = 0;
        this[status + 'List'] = [];
    },

    /**
     * 存储可以触摸的节点
     * @param  {cc.Node} node 保存当前节点
     * @param  {cc.Node} cnNode 保存函数调用节点
     * @param  {String} alias  别名
     * @param  {String} funcName  需要调用的函数名
     */
    addTouchToList(node, cnNode, alias, funcName, param = null) {
        node.alias = alias;
        node.cnNode = cnNode;
        node.fn = funcName;
        node.param = param;
        this[this.curStatus + 'List'].push(node);
    },

    removeByValue(val) {
        if (!val) {
            cc.warn(this._TAG + ' removeByValue param error ' + val);
            return;
        }
        for (let i = 0; i < this[this.curStatus + 'List'].length; i++) {
            if (this[this.curStatus + 'List'][i] === val) {
                this[this.curStatus + 'List'].splice(i, 1);
                break;
            }
        }
        if (this[this.curStatus + 'Count'] >= this[this.curStatus + 'List'].length) {
            this[this.curStatus + 'Count'] = 0;
        }
        // cc.log(this[this.curStatus + 'List'].length + ',' + this[this.curStatus + 'Count']);
    },
};
tv.init();
