(function() {"use strict";var __module = CC_EDITOR ? module : {exports:{}};var __filename = 'preview-scripts/assets/script/TVKeyboardMgr.js';var __require = CC_EDITOR ? function (request) {return cc.require(request, require);} : function (request) {return cc.require(request, __filename);};function __define (exports, require, module) {"use strict";
cc._RF.push(module, '283e0XHk6lNLowx29BtMi1e', 'TVKeyboardMgr', __filename);
// plugins/tv/TVKeyboardMgr.js

'use strict';

// tv键盘事件管理
// NOTE:脚本需要在全局脚本之后，其他脚本之前执行（例如挂在Canvas节点上）

cc.Class({
    extends: cc.Component,

    properties: {
        lbKeycode: cc.Label,
        cursor: cc.Node,
        _flag: true, //判断加减
        _isMove: true //判断是否需要移动光标
    },

    onLoad: function onLoad() {
        this.node.className = 'TVKeyboardMgr';
        this.cursor.zIndex = 999;
        cc.systemEvent.on('keyup', this.onKeyUp, this);
        cc.systemEvent.on('keydown', this.onKeyDown, this);
        tv.customEvent.on('cursor', this.listenCursor, this);
        // cc.log(cc.KEY);
    },
    onDestroy: function onDestroy() {
        cc.systemEvent.off('keyup', this.onKeyUp, this);
        cc.systemEvent.off('keydown', this.onKeyDown, this);
        tv.customEvent.off('cursor', this.listenCursor, this);
    },
    listenCursor: function listenCursor(event) {
        // cc.log(event.detail.pos);
        this.cursor.position = event.detail.pos;
    },
    log: function log(str, code) {
        // cc.log(str);
        this.lbKeycode.string = str + code;
    },
    jumpStatus: function jumpStatus() {
        if (tv.curStatus === tv.status.start) {
            tv.curStatus = tv.status.choose;
        } else if (tv.curStatus === tv.status.choose) {
            tv.curStatus = tv.status.start;
        }
        tv.emit(tv[tv.curStatus + 'List'][tv[tv.curStatus + 'Count']]);
    },
    action: function action(node) {
        try {
            if (!node) {
                cc.log('param error');
                cc.log(node);
                return;
            }
            if (node.cnNode == 'self') {
                // cc.log(`self idx:${tv[tv.curStatus + 'Count']} alias:${node.alias} className:${node.className} funcName:${node.fn}`);
                node.getComponent(node.className)[node.fn](node.param);
            } else {
                // cc.log(`not self idx:${tv[tv.curStatus + 'Count']} alias:${node.alias} className:${node.cnNode.className} funcName:${node.fn}`);
                node.cnNode.getComponent(node.cnNode.className)[node.fn](node.param);
            }
        } catch (error) {
            cc.log(error);
        }
    },


    /**
     * 键    cocos默认键值   小米盒子测试键值
     * 上    1003            1003
     * 下    1004            1004
     * 左    1000            1000
     * 右    1001            1001
     * 确定  1005            13  (小米盒子确定键使用的是全键盘的enter)
     * 返回  6               6
     * 菜单  18              18
     */

    onKeyUp: function onKeyUp(event) {
        switch (event.keyCode) {
            case cc.KEY.w:
            case cc.KEY.dpadUp:
                //1003
                this.log('onKeyUp up', event.keyCode);
                break;
            case cc.KEY.s:
            case cc.KEY.dpadDown:
                //1004
                this.log('onKeyUp down', event.keyCode);
                break;
            case cc.KEY.a:
            case cc.KEY.dpadLeft:
                //1000
                this.log('onKeyUp left', event.keyCode);
                break;
            case cc.KEY.d:
            case cc.KEY.dpadRight:
                //1001
                this.log('onKeyUp right', event.keyCode);
                break;
            case cc.KEY.space:
            case cc.KEY.dpadCenter: //1005
            case cc.KEY.enter:
                //13
                this.log('onKeyUp center', event.keyCode);
                break;
            case cc.KEY.escape:
            case cc.KEY.back:
                //6
                this.log('onKeyUp back', event.keyCode);
                break;
            case cc.KEY.f1:
            case cc.KEY.menu:
                //18
                this.log('onKeyUp menu', event.keyCode);
                break;
        }
    },
    onKeyDown: function onKeyDown(event) {
        this._isMove = true;
        switch (event.keyCode) {
            case cc.KEY.w:
            case cc.KEY.dpadUp:
                //1003
                this.log('onKeyDown up', event.keyCode);
                tv[tv.curStatus + 'Count']--;
                this._flag = false;
                break;
            case cc.KEY.s:
            case cc.KEY.dpadDown:
                //1004
                this.log('onKeyDown down', event.keyCode);
                tv[tv.curStatus + 'Count']++;
                this._flag = true;
                break;
            case cc.KEY.a:
            case cc.KEY.dpadLeft:
                //1000
                this.log('onKeyDown left', event.keyCode);
                tv[tv.curStatus + 'Count']--;
                this._flag = false;
                break;
            case cc.KEY.d:
            case cc.KEY.dpadRight:
                //1001
                this.log('onKeyDown right', event.keyCode);
                tv[tv.curStatus + 'Count']++;
                this._flag = true;
                break;
            case cc.KEY.space:
            case cc.KEY.dpadCenter: //1005
            case cc.KEY.enter:
                //13
                this.log('onKeyDown center', event.keyCode);
                this._isMove = false;
                this.action(tv[tv.curStatus + 'List'][tv[tv.curStatus + 'Count']]);
                break;
            case cc.KEY.escape:
            case cc.KEY.back:
                //6
                this.log('onKeyDown back', event.keyCode);
                this._isMove = false;
                break;
            case cc.KEY.f1:
            case cc.KEY.menu:
                //18
                this.log('onKeyDown menu', event.keyCode);
                this._isMove = false;
                break;
        }

        if (tv[tv.curStatus + 'Count'] < 0) {
            tv[tv.curStatus + 'Count'] = tv[tv.curStatus + 'List'].length - 1;
        } else if (tv[tv.curStatus + 'Count'] >= tv[tv.curStatus + 'List'].length) {
            tv[tv.curStatus + 'Count'] = 0;
        }

        if (this._isMove) {
            this.cursor.position = tv.convertPos(tv[tv.curStatus + 'List'][tv[tv.curStatus + 'Count']]);
        }
    }
});

cc._RF.pop();
        }
        if (CC_EDITOR) {
            __define(__module.exports, __require, __module);
        }
        else {
            cc.registerModuleFunc(__filename, function () {
                __define(__module.exports, __require, __module);
            });
        }
        })();
        //# sourceMappingURL=TVKeyboardMgr.js.map
        