import { _decorator, Component, Node, BoxColliderComponent, ITriggerEvent, ColliderComponent, Vec3, Vec2 } from "cc";
// import { EnemyCtrl } from "../Enemy/EnemyCtrl";
import { PlayerCtrl } from "../Player/PlayerCtrl";
const { ccclass, property } = _decorator;

@ccclass("BulletCtrl")
export class BulletCtrl extends Component {

  //子弹的方向,只是一个单位向量，总长为1的
  public direct: Vec3 = null;

  //子弹的速度
  public speed: number = 3;

  //子弹的伤害
  public damage: number = 1;

  //子弹能够飞行的最大的距离
  public flightDistance:number =1;

  //自己的出生点
  public bornPos:Vec3 = cc.v3();

  //碰撞体
  public boxCollider:BoxColliderComponent = null;


  private _isPause:boolean = false;
  public get isPause(){
    return this._isPause;
  }
  public set isPause(val:boolean){
    this._isPause = val;
  }
  
  start() {
    this.boxCollider = this.getComponent(BoxColliderComponent);
    const group = 1 << 2;
    this.boxCollider.setGroup(group);
    const mask = 1 << 2;
    this.boxCollider.setMask(group);

    this.boxCollider.on("onTriggerExit", this.onTriggerExit, this);
  }

  //初始化自己的属性
  init(config:any){
    this.speed = config.speed;
    this.damage = config.damage;
    this.flightDistance = config.flightDistance;
  }

  onDestroy() {
    // let boxCollider:BoxColliderComponent = this.getComponent(BoxColliderComponent);
    // this.boxCollider.off("onTriggerEnter", this.onTriggerEnter, this);
  }

  onTriggerExit(event: ITriggerEvent) {
    // if (cc.isValid(this.node, true) == false)
    //   return;

    // let otherCollider: ColliderComponent = event.otherCollider;
    // if(otherCollider == null || otherCollider.node == null)
    //   return;
    
    // let enemyCtrl = otherCollider.getComponent(EnemyCtrl);
    // if (enemyCtrl && cc.isValid(enemyCtrl.node, true)) {
    //   this.boxCollider.off("onTriggerExit", this.onTriggerExit, this);
    //   this.node.destroy();
    //   enemyCtrl.getHurt(this.damage);
    //   // cc.log("子弹撞到怪物了");
    // }
  }

  setDirect(direct: Vec3) {
    this.direct = direct;
    let angleVec2: Vec2 = cc.v2(direct.x, -direct.z);
    let angle: number = Vec2.angle(cc.v2(1, 0), angleVec2);
    if (angleVec2.y <= 0)
      angle = -angle;
    let rotation = angle * 180 / Math.PI;
    this.node.setRotationFromEuler(0, rotation + 90, 0);
  }

  setBornPos(bornPos:Vec3){
    this.bornPos = bornPos;
    this.node.setPosition(bornPos);
  }


}
