import { _decorator, Component, Node, BoxColliderComponent, SphereColliderComponent } from "cc";
const { ccclass, property } = _decorator;

@ccclass("ProtectvieCtrl")
export class ProtectvieCtrl extends Component {
   
  private _isPause:boolean = false;
  public get isPause(){
    return this._isPause;
  }
  public set isPause(val:boolean){
    this._isPause = val;
  }

    protected timeLimit:number = 0;

    start () {
      let sphereCollider:SphereColliderComponent = this.getComponent(SphereColliderComponent);
      sphereCollider.setMask(1<<4);
      sphereCollider.setGroup(1<<4);
    }

    setTimeLimit(val:number){
      this.timeLimit = val;
      if(this.timeLimit > 0){
        this.node.active = true;
        this.schedule(this.updateForTimeLimit,0.5);
      }
    }
    
    updateForTimeLimit(dt:number){
      if(this.isPause){
        return;
      }

      this.timeLimit -=dt;
      if(this.timeLimit <0){
        this.unschedule(this.updateForTimeLimit);
        this.node.active = false;
      }
    }

    // update (deltaTime: number) {
    //     // Your update function goes here.
    // }
}
