

export let LocalData = {

  _currentGunIndex:0,
  get currentGunIndex(){
    return this._currentGunIndex;
  },
  set currentGunIndex(val){
    this._currentGunIndex = val;
    NotificationCenter.postNotice(NCKeys.CUR_GUN_INDEX_CHANGED, this._currentGunIndex);
  },


  initDefaultLocalData(){
    Object.assign(defaultLocalData, this);
  },

  load(){
    let str:string = cc.sys.localStorage.getItem("LocalData");    
    if(str != null && str != ""){
      var json:object =  JSON.parse(str);
      Object.assign(this, json);
    }
    else{
      //todo init存档

    }
  },

  save(){
    let str:String = JSON.stringify(this);
    cc.sys.localStorage.setItem(str);
  },

  clear(){
    cc.sys.localStorage.removeItem("LocalData");
    Object.assign(this, defaultLocalData);
    this.load();
  }
};

let defaultLocalData:object = {};
