
//一个全局的通知中心
let NCKeys = {
  CUR_GUN_INDEX_CHANGED:"CUR_GUN_INDEX_CHANGED", //当前玩家使用的枪的编号发生了变化
  
}

let NotificationCenter = {

    _observers:{},

    addObserver:function (key,fun,target) {

        cc.assert(key != null,'key  cant be null');
        cc.assert(fun != null,'fun  cant be null');
        cc.assert(target != null,'target  cant be null');

        if(this._observers[key] == null)
            this._observers[key] = [];

        this._observers[key].push({fun:fun,target:target});
    },

    removeObserver:function (key,target) {
        if(target == null)
            cc.assert(false,'target must not be null');

        if(this._observers[key] == null)
            return;

        this._observers[key] = this._observers[key].filter(function (item) {
            return item.target != target;
        });
    },

    postNotice:function (key, data) {

        if(this._observers[key] == null)
            return;

        this._observers[key].forEach(function (item) {
            item.fun.call(item.target,data);
        })
    },
};

window.NotificationCenter = NotificationCenter;
window.NCKeys = NCKeys;

// export {NotificationCenter, NCKeys};


