import { CameraComponent, SpriteComponent, SpriteFrame, RenderTexture } from "cc";

export let Utils = {

  transformCameraToSprite(camera:CameraComponent, sprite:SpriteComponent){
    const spriteframe = sprite.spriteFrame;
    const sp = new SpriteFrame();
    sp.reset({
      originalSize: spriteframe.getOriginalSize(),
      rect: spriteframe.getRect(),
      offset: spriteframe.getOffset(),
      isRotate: spriteframe.isRotated(),
      borderTop: spriteframe.insetTop,
      borderLeft: spriteframe.insetLeft,
      borderBottom: spriteframe.insetBottom,
      borderRight: spriteframe.insetRight,
    });

    const rendetTex = new RenderTexture();
    rendetTex.reset({
      width: sprite.node.width,
      height: sprite.node.height,
      colorFormat: RenderTexture.PixelFormat.RGBA8888,
      depthStencilFormat: RenderTexture.DepthStencilFormat.DEPTH_24_STENCIL_8
    });
    camera.targetTexture = rendetTex;
    sp.texture = rendetTex;
    sprite.spriteFrame = sp;
  }
  



};