"use strict";

System.register(["cc", "./BulletCtrl.ts", "../../IndependentScript/Config.ts"], function (_export, _context) {
  "use strict";

  var _decorator, Component, Node, Prefab, Vec3, instantiate, BulletCtrl, Config, _dec, _dec2, _dec3, _class, _class2, _descriptor, _descriptor2, _temp, ccclass, property, BulletManagerCtrl;

  _export({
    _dec: void 0,
    _dec2: void 0,
    _dec3: void 0,
    _class: void 0,
    _class2: void 0,
    _descriptor: void 0,
    _descriptor2: void 0,
    _temp: void 0
  });

  return {
    setters: [function (_cc) {
      _decorator = _cc._decorator;
      Component = _cc.Component;
      Node = _cc.Node;
      Prefab = _cc.Prefab;
      Vec3 = _cc.Vec3;
      instantiate = _cc.instantiate;
    }, function (_BulletCtrlTs) {
      BulletCtrl = _BulletCtrlTs.BulletCtrl;
    }, function (_IndependentScriptConfigTs) {
      Config = _IndependentScriptConfigTs.Config;
    }],
    execute: function () {
      cc._RF.push(window.module || {}, "23f99Y0dyNEn7uCm4sWK+f/", "BulletManagerCtrl"); // begin BulletManagerCtrl


      ccclass = _decorator.ccclass;
      property = _decorator.property;

      _export("BulletManagerCtrl", BulletManagerCtrl = (_dec = ccclass("BulletManagerCtrl"), _dec2 = property({
        type: Prefab
      }), _dec3 = property({
        type: Node
      }), _dec(_class = (_class2 = (_temp =
      /*#__PURE__*/
      function (_Component) {
        babelHelpers.inherits(BulletManagerCtrl, _Component);

        function BulletManagerCtrl() {
          var _babelHelpers$getProt;

          var _this;

          babelHelpers.classCallCheck(this, BulletManagerCtrl);

          for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
            args[_key] = arguments[_key];
          }

          _this = babelHelpers.possibleConstructorReturn(this, (_babelHelpers$getProt = babelHelpers.getPrototypeOf(BulletManagerCtrl)).call.apply(_babelHelpers$getProt, [this].concat(args)));
          _this._isPause = false;
          babelHelpers.initializerDefineProperty(_this, "bulletPrefab", _descriptor, babelHelpers.assertThisInitialized(_this));
          babelHelpers.initializerDefineProperty(_this, "playerNode", _descriptor2, babelHelpers.assertThisInitialized(_this));
          return _this;
        }

        babelHelpers.createClass(BulletManagerCtrl, [{
          key: "start",
          value: function start() {}
        }, {
          key: "update",
          value: function update(deltaTime) {
            if (this.isPause == true) {
              return;
            }

            this.updateForBulletsPos(deltaTime);
            this.updateForBulletDistance(deltaTime);
          } // _updateForTest(dt:number){
          //   this.createBullet(cc.v3(0,0.8,0),  cc.v3(0,0,-1));
          // }

        }, {
          key: "createBullet",
          value: function createBullet(bulletIndex, bulletPos, direct) {
            var bullet = instantiate(this.bulletPrefab);
            var bulletCtrl = bullet.getComponent(BulletCtrl);
            direct.normalize();
            bulletCtrl.setDirect(direct);
            bulletCtrl.setBornPos(bulletPos);
            bulletCtrl.init(Config.GunConfig[bulletIndex]);
            bullet.setParent(this.node);
          }
        }, {
          key: "updateForBulletsPos",
          value: function updateForBulletsPos(dt) {
            var children = this.node.children;

            for (var i = 0; i < children.length; i++) {
              var bullet = children[i];

              if (cc.isValid(bullet, true)) {
                var bulletCtrl = bullet.getComponent(BulletCtrl);
                var offset = cc.v3();
                Vec3.multiplyScalar(offset, bulletCtrl.direct, bulletCtrl.speed * dt);
                Vec3.add(offset, bullet.getPosition(), offset);
                bullet.setPosition(offset);
              }
            }
          }
        }, {
          key: "updateForBulletDistance",
          value: function updateForBulletDistance(dt) {
            var children = this.node.children;

            for (var i = 0; i < children.length; i++) {
              var bullet = children[i];

              if (cc.isValid(bullet, true)) {
                var bulletCtrl = bullet.getComponent(BulletCtrl);
                var bornPos = bulletCtrl.bornPos;
                var curPos = bullet.getPosition();
                var distance = Vec3.distance(bornPos, curPos);

                if (distance > bulletCtrl.flightDistance) {
                  bulletCtrl.boxCollider.off("onTriggerExit", bulletCtrl.onTriggerExit, bulletCtrl);
                  bullet.destroy();
                  cc.log("一颗子弹因为达到了自己的最大射程而死亡了");
                }
              }
            }
          }
        }, {
          key: "isPause",
          get: function get() {
            return this._isPause;
          },
          set: function set(val) {
            this._isPause = val;
            var childern = this.node.children;

            for (var i = 0; i < childern.length; i++) {
              var node = childern[i];

              if (cc.isValid(node, true)) {
                var bulletCtrl = node.getComponent(BulletCtrl);
                bulletCtrl.isPause = val;
              }
            }
          }
        }]);
        return BulletManagerCtrl;
      }(Component), _temp), (_descriptor = babelHelpers.applyDecoratedDescriptor(_class2.prototype, "bulletPrefab", [_dec2], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: function initializer() {
          return null;
        }
      }), _descriptor2 = babelHelpers.applyDecoratedDescriptor(_class2.prototype, "playerNode", [_dec3], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: function initializer() {
          return null;
        }
      })), _class2)) || _class));

      cc._RF.pop(); // end BulletManagerCtrl

    }
  };
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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