"use strict";

System.register(["cc", "../Bullet/BulletManagerCtrl.ts", "./ProtectvieCtrl.ts"], function (_export, _context) {
  "use strict";

  var _decorator, Component, Node, Vec3, BoxColliderComponent, BulletManagerCtrl, ProtectvieCtrl, _dec, _dec2, _dec3, _dec4, _dec5, _class, _class2, _descriptor, _descriptor2, _descriptor3, _descriptor4, _temp, ccclass, property, PlayerCtrl;

  _export({
    _dec: void 0,
    _dec2: void 0,
    _dec3: void 0,
    _dec4: void 0,
    _dec5: void 0,
    _class: void 0,
    _class2: void 0,
    _descriptor: void 0,
    _descriptor2: void 0,
    _descriptor3: void 0,
    _descriptor4: void 0,
    _temp: void 0
  });

  return {
    setters: [function (_cc) {
      _decorator = _cc._decorator;
      Component = _cc.Component;
      Node = _cc.Node;
      Vec3 = _cc.Vec3;
      BoxColliderComponent = _cc.BoxColliderComponent;
    }, function (_BulletBulletManagerCtrlTs) {
      BulletManagerCtrl = _BulletBulletManagerCtrlTs.BulletManagerCtrl;
    }, function (_ProtectvieCtrlTs) {
      ProtectvieCtrl = _ProtectvieCtrlTs.ProtectvieCtrl;
    }],
    execute: function () {
      cc._RF.push(window.module || {}, "32752Gt0zdNELz2XTxEY/T3", "PlayerCtrl"); // begin PlayerCtrl


      ccclass = _decorator.ccclass;
      property = _decorator.property;

      _export("PlayerCtrl", PlayerCtrl = (_dec = ccclass("PlayerCtrl"), _dec2 = property({
        type: BulletManagerCtrl
      }), _dec3 = property({
        type: Node
      }), _dec4 = property({
        type: Node
      }), _dec5 = property({
        type: BoxColliderComponent
      }), _dec(_class = (_class2 = (_temp =
      /*#__PURE__*/
      function (_Component) {
        babelHelpers.inherits(PlayerCtrl, _Component);

        function PlayerCtrl() {
          var _babelHelpers$getProt;

          var _this;

          babelHelpers.classCallCheck(this, PlayerCtrl);

          for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
            args[_key] = arguments[_key];
          }

          _this = babelHelpers.possibleConstructorReturn(this, (_babelHelpers$getProt = babelHelpers.getPrototypeOf(PlayerCtrl)).call.apply(_babelHelpers$getProt, [this].concat(args)));
          babelHelpers.initializerDefineProperty(_this, "bulletManagerCtrl", _descriptor, babelHelpers.assertThisInitialized(_this));
          babelHelpers.initializerDefineProperty(_this, "skeleNode", _descriptor2, babelHelpers.assertThisInitialized(_this));
          babelHelpers.initializerDefineProperty(_this, "protecivieNode", _descriptor3, babelHelpers.assertThisInitialized(_this));
          _this.enemyTraget = null;
          _this.hp = 100;
          _this.speed = cc.v3();
          _this.gunConfig = {};
          _this._isPause = false;
          _this._acceleration = null;
          _this.minSwitchTargetInterval = 1;
          _this.cumulativeSwitchTargetTime = 0;
          _this.minFireInterval = 0.1;
          _this.cumulativeFireTime = 0;
          babelHelpers.initializerDefineProperty(_this, "boxCollider", _descriptor4, babelHelpers.assertThisInitialized(_this));
          _this.bulletNum = 0;
          return _this;
        }

        babelHelpers.createClass(PlayerCtrl, [{
          key: "start",
          value: function start() {
            //设置分组掩码
            var group = (1 << 3) + (1 << 1);
            this.boxCollider.setGroup(group);
            var mask = (1 << 3) + (1 << 1);
            this.boxCollider.setMask(mask); //监听事件

            this.boxCollider.on("onTriggerEnter", this.onTriggerEnter, this); // this.boxCollider.on("onCollisionStay", this.onCollisionStay, this);
            // this.boxCollider.on("onCollisionExit", this.onCollisionExit, this);
          }
        }, {
          key: "onDestroy",
          value: function onDestroy() {// this.boxCollider.off("onCollisionEnter", this.onCollisionEnter, this);
            // this.boxCollider.off("onCollisionStay", this.onCollisionStay, this);
            // this.boxCollider.off("onCollisionExit", this.onCollisionExit, this);
          }
        }, {
          key: "initGun",
          value: function initGun(config) {
            //todo 初始化自己的gun
            this.minFireInterval = 1.0 / config.firingRate;
          }
        }, {
          key: "onTriggerEnter",
          value: function onTriggerEnter(event) {
            if (this.isPause || this.isDead()) return; //   let otherCollider: ColliderComponent = event.otherCollider;
            //   if(otherCollider== null || otherCollider.node == null)
            //     return;
            //   let enemyCtrl = otherCollider.getComponent(EnemyCtrl);
            //   if (enemyCtrl) {
            //     //先判断敌人是否是存活的
            //     if (cc.isValid(enemyCtrl.node, true)) {
            //       enemyCtrl.playAttackAnimation();
            //       this.modifyHp(-enemyCtrl.damage);
            //     }
            //   }
          } // onCollisionStay(event: ICollisionEvent) {
          // }
          // onCollisionExit(event: ICollisionEvent) {
          // }

        }, {
          key: "modifyHp",
          value: function modifyHp(val) {
            this.hp += val;
            cc.log("hero hp is: " + this.hp);
          }
        }, {
          key: "isDead",
          value: function isDead() {
            return this.hp <= 0;
          }
        }, {
          key: "update",
          value: function update(dt) {
            if (this.isPause) return;
            this.updateForSpeedAndPos(dt);
            this.updateForEnemyTarget(dt);
            this.updateForDirectionAndFire(dt);
            this.updateForProteciviePos(dt);
          } //先更新速度，再根据速度更新自己的位置

        }, {
          key: "updateForSpeedAndPos",
          value: function updateForSpeedAndPos(dt) {
            if (this.acceleration == null) {
              if (this.speed.length() != 0) {
                //没有加速度的说，那么这个时候手指就从屏幕上下来了
                var acceleration = cc.v3(this.speed);
                acceleration.normalize();
                Vec3.multiplyScalar(acceleration, acceleration, 2 * dt);

                if (this.speed.length() < acceleration.length()) {
                  this.speed = cc.v3(Vec3.ZERO);
                } else {
                  Vec3.subtract(this.speed, this.speed, acceleration);
                }
              }
            } else {
              //有加速度说明手指还在屏幕上呢
              this.speed.x += dt * this.acceleration.x;
              this.speed.y += dt * this.acceleration.y;
              this.speed.z += dt * this.acceleration.z;
            } //如果速度超过了10, 那么就需要限制


            var maxSpeed = 3;

            if (this.speed.length() > maxSpeed) {
              this.speed.normalize();
              var newSpeed = cc.v3();
              Vec3.multiplyScalar(newSpeed, this.speed, maxSpeed);
              this.speed = newSpeed;
            }

            var oldPos = this.node.getPosition();
            var newPos = cc.v3();
            Vec3.scaleAndAdd(newPos, oldPos, this.speed, dt);
            this.node.setPosition(newPos);
          } //更新自己的目标敌人是谁

        }, {
          key: "updateForEnemyTarget",
          value: function updateForEnemyTarget(dt) {// this.cumulativeSwitchTargetTime += dt;
            // if (this.enemyTraget == null || !cc.isValid(this.enemyTraget, true) || this.cumulativeSwitchTargetTime >= this.minSwitchTargetInterval) {
            //   this.enemyTraget = this.enemyManagerCtrl.getClosestEnemy();
            //   this.cumulativeSwitchTargetTime = 0.0;
            // }
          }
        }, {
          key: "updateForDirectionAndFire",
          //更新自己的旋转角度和开火
          value: function updateForDirectionAndFire(dt) {
            this.bulletManagerCtrl.createBullet(0, cc.v3(0, 1, 0), cc.v3(0, 0, -1));
            this.cumulativeFireTime = 0;
            this.bulletNum++;
            cc.log("创建了：" + this.bulletNum + "：子弹"); // if (this.enemyTraget) {
            //   let enemyPos = this.enemyTraget.getPosition();
            //   let selfPos = this.node.getPosition();
            //   let localPos = cc.v2(enemyPos.x - selfPos.x, -(enemyPos.z - selfPos.z));
            //   let angle: number = Vec2.angle(cc.v2(1, 0), localPos);
            //   if (localPos.y <= 0)
            //     angle = -angle;
            //   let rotation = angle * 180 / Math.PI;
            //   this.skeleNode.setRotationFromEuler(0, rotation + 90, 0);
            //   this.cumulativeFireTime += dt;
            //   if (this.cumulativeFireTime > this.minFireInterval) {
            //     let bulletPos = this.node.getPosition();
            //     let offsetPos: Vec3 = cc.v3();
            //     Vec3.subtract(offsetPos, enemyPos, selfPos);
            //     offsetPos.normalize();
            //     offsetPos.y = 0;
            //     Vec3.scaleAndAdd(bulletPos, bulletPos, offsetPos, 0.6);
            //     bulletPos.y = 0.8;
            //     this.bulletManagerCtrl.createBullet(0, bulletPos, offsetPos);
            //     this.cumulativeFireTime = 0;
            //   }
            // }
          }
        }, {
          key: "updateForProteciviePos",
          value: function updateForProteciviePos(dt) {} // this.protecivieNode.setPosition(cc.v3(0,0.331,0));
          // update (deltaTime: number) {
          //     // Your update function goes here.
          // }

        }, {
          key: "isPause",
          get: function get() {
            return this._isPause;
          },
          set: function set(val) {
            this._isPause = val; //设置防护罩的暂停状态

            var protectiveNode = this.node.getChildByName('protective');
            var protectiveCtrl = protectiveNode.getComponent(ProtectvieCtrl);
            protectiveCtrl.isPause = val;
          } //小人当前的加速度

        }, {
          key: "acceleration",
          set: function set(_a) {
            if (_a == null || _a.length() == 0) this._acceleration = null;else this._acceleration = _a;
          },
          get: function get() {
            return this._acceleration;
          } //切换目标需要的最小时间，如果没有这个东西，会出现快速频繁的再几个目标之间切换，会抖动

        }]);
        return PlayerCtrl;
      }(Component), _temp), (_descriptor = babelHelpers.applyDecoratedDescriptor(_class2.prototype, "bulletManagerCtrl", [_dec2], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: function initializer() {
          return null;
        }
      }), _descriptor2 = babelHelpers.applyDecoratedDescriptor(_class2.prototype, "skeleNode", [_dec3], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: function initializer() {
          return null;
        }
      }), _descriptor3 = babelHelpers.applyDecoratedDescriptor(_class2.prototype, "protecivieNode", [_dec4], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: function initializer() {
          return null;
        }
      }), _descriptor4 = babelHelpers.applyDecoratedDescriptor(_class2.prototype, "boxCollider", [_dec5], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: function initializer() {
          return null;
        }
      })), _class2)) || _class));

      cc._RF.pop(); // end PlayerCtrl

    }
  };
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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