"use strict";

System.register(["cc"], function (_export, _context) {
  "use strict";

  var SpriteFrame, RenderTexture, Utils;
  return {
    setters: [function (_cc) {
      SpriteFrame = _cc.SpriteFrame;
      RenderTexture = _cc.RenderTexture;
    }],
    execute: function () {
      cc._RF.push(window.module || {}, "f8e0aQ9pjNNy6bdDdfv0ZO3", "Utils"); // begin Utils


      _export("Utils", Utils = {
        transformCameraToSprite: function transformCameraToSprite(camera, sprite) {
          var spriteframe = sprite.spriteFrame;
          var sp = new SpriteFrame();
          sp.reset({
            originalSize: spriteframe.getOriginalSize(),
            rect: spriteframe.getRect(),
            offset: spriteframe.getOffset(),
            isRotate: spriteframe.isRotated(),
            borderTop: spriteframe.insetTop,
            borderLeft: spriteframe.insetLeft,
            borderBottom: spriteframe.insetBottom,
            borderRight: spriteframe.insetRight
          });
          var rendetTex = new RenderTexture();
          rendetTex.reset({
            width: sprite.node.width,
            height: sprite.node.height,
            colorFormat: RenderTexture.PixelFormat.RGBA8888,
            depthStencilFormat: RenderTexture.DepthStencilFormat.DEPTH_24_STENCIL_8
          });
          camera.targetTexture = rendetTex;
          sp.texture = rendetTex;
          sprite.spriteFrame = sp;
        }
      });

      cc._RF.pop(); // end Utils

    }
  };
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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