cc.Class({
    extends: cc.Component,

    properties: {
        near_bg: [cc.Node],
        far_bg: [cc.Node],

        near_speed: 1,
        far_speed: 0.5,
    },

    // use this for initialization
    onLoad: function () {
        this.fixBgPos(this.far_bg[0], this.far_bg[1],this.far_bg[2], this.far_bg[3]);
        this.fixBgPos(this.near_bg[0], this.near_bg[1],this.near_bg[2], this.near_bg[3]);
    },
//注意要在层级管理器background组，进行节点关联数组
    fixBgPos: function (bg1, bg2,bg3, bg4)
    {
        bg1.x = 0;
        var bg1BoundingBox = bg1.getBoundingBox();
        bg2.setPosition(bg1BoundingBox.xMax, bg1BoundingBox.yMin);
         var bg2BoundingBox = bg2.getBoundingBox();
        bg3.setPosition(bg2BoundingBox.xMax, bg2BoundingBox.yMin);
         var bg3BoundingBox = bg3.getBoundingBox();
        bg4.setPosition(bg3BoundingBox.xMax, bg3BoundingBox.yMin);
    },

    // called every frame, uncomment this function to activate update callback
    update: function (dt) 
    {
        this.bgMove(this.far_bg, this.far_speed);
        this.bgMove(this.near_bg, this.near_speed);
        this.checkBgReset(this.far_bg);
        this.checkBgReset(this.near_bg);
    },

    bgMove:function(bgList, speed)
    {
        for (var index = 0; index < bgList.length; index++) 
        {
            var element = bgList[index];
            element.x -= speed;
        }
    },

    /***
     * 检查背景是否要重置位置
     */
    checkBgReset:function(bgList)
    {
        var winSize = cc.director.getWinSize();
        var first_xMax = bgList[0].getBoundingBox().xMax;
        if (first_xMax <= 0) 
        {
            var preFirstBg = bgList.shift();
            bgList.push(preFirstBg);

            var curFirstBg = bgList[0];
            preFirstBg.x = curFirstBg.getBoundingBox().xMax;
        }
    }
});
