var BaseDialog = require("BaseDialog");
let AlertDialog = cc.Class({
    extends: BaseDialog,

    statics:
    {
        DIALOG_BTN_YES : 1,
        DIALOG_BTN_NO :2,
        DIALOG_BTN_IGNORE :3,
    },

    properties: {
        //clickCallback : null, // 点击按钮回调

        btnYes: cc.Node,
        btnNo: cc.Node,
        btnIgnore: cc.Node,
        contentLabel: cc.Node,
        bgMask : cc.Node,
        bg : cc.Node,

        _clickCallback : null,

        _maskOpacity : 0,
    },

    onLoad : function()
    {
        cc.log("AlertDialog onLoad");
        this._super();

        if(this.btnYes)
        {
            this.btnYes.on("click", ()=> {
                if(this._clickCallback)
                {
                    this._clickCallback(this, AlertDialog.DIALOG_BTN_YES);
                }
            });
        }
        if(this.btnNo)
        {
            this.btnNo.on("click", ()=> {
                if(this._clickCallback)
                {
                    this._clickCallback(this, AlertDialog.DIALOG_BTN_NO);
                }
            });
        }
        if(this.btnIgnore)
        {
            this.btnIgnore.on("click", ()=> {
                if(this._clickCallback)
                {
                    this._clickCallback(this,AlertDialog.DIALOG_BTN_IGNORE);
                }
            });
        }

        if(this.bgMask)
        {
            this._maskOpacity = this.bgMask.opacity;
        }
    },


    _hide: function (delay)
    {
        if(this.isShowing())
        {
            this.node.setPosition(cc.p(0,0));
            if(this.bgMask)
            {
                this.bgMask.stopAllActions();
                this.bgMask.runAction(cc.fadeTo(0, this._maskOpacity));
            }
            if(this.bg)
            {
                this.bg.stopAllActions();
                this.bg.runAction(cc.scaleTo(0.2,0));
            }
        }
        this._super(0.2);
    },

    show : function()
    {
        if(!this.isShowing())
        {
            this.node.setPosition(cc.p(0,0));
            if(this.bgMask)
            {
                this.bgMask.stopAllActions();
                this.bgMask.opacity = 0;
                this.bgMask.runAction(cc.fadeTo(1, this._maskOpacity));
            }
            if(this.bg)
            {
                this.bg.stopAllActions();
                this.bg.setScale(0.8);
                this.bg.runAction(cc.scaleTo(0.4,1).easing(cc.easeCircleActionOut()));
            }
        }

        this._super();
    },

    // 设置弹窗消息内容
    setMessage : function(contentMsg)
    {
        if(this.contentLabel)
        {
            if(this.contentLabel.getComponent(cc.Label))
            {
                this.contentLabel.getComponent(cc.Label).string = contentMsg
            }
            else if(this.contentLabel.getComponent(cc.RichText))
            {
                this.contentLabel.getComponent(cc.RichText).string = contentMsg
            }
        }
    },

    // 设置按钮点击回调
    setClickCallback : function(callbackFun)
    {
        this._clickCallback = callbackFun;
    }
});
