// var FocusManager = require("FocusManager");

cc.Class({
    extends: cc.Component,

    properties: {
        _isHide: true,
        _defaultFocusNode : "", // 默认焦点

        _isInited : false,

        _showAddZIndex : 0,
        _isHiding : false,
        _isShowCalled : false,
    },

    // use this for initialization
    onLoad: function () {
        cc.log("BaseDialog onLoad");
        this._init();
        this.node.active = false;// 默认隐藏
    },

    start : function()
    {
        // if(!this._isShowCalled)
        // {
        //     this.node.active = false;// 默认隐藏
        // }
    },

    onEnable : function()
    {
        this._init();
    },

    _init : function()
    {
        if(!this._isInited)
        {
            let backCallback = (event)=>this.hide();
            this.init();
            this._isInited = true;
        }
    },

    _backCallback : function()
    {
        this.hide();
    },

    hide: function () {
        this._hide(0);
    },

    _hide: function (delay) {

        if(!cc.isValid(delay))
        {
            delay = 0;
        }

        this._isShowCalled = false;
        if(this.node.active)
        {
            this._isHiding = true;
            this.node.stopActionByTag(9999);

            if (this._isHide) {
                this.node.off("backpress", this._backCallback, this);
            }
            this.node.emit("fade-out");
            // FocusManager.getInstance().resumeFocus();
            this.node.zIndex = this.node.zIndex - this._showAddZIndex;
            this._showAddZIndex = 0;

            let action = cc.sequence(cc.delayTime(delay), cc.callFunc(()=>{
                this._isHiding = false;
                this.node.active = false;
            }));
            action.setTag(9999);
            this.node.runAction(action);
        }
    },

    dismiss : function()
    {
        this.hide();
        this.node.removeFromParent(true);
    },

    show: function () {

        if(!this.node.active || this._isHiding)
        {
            this.node.active = true;
            if(this._isHiding)
            {
                this.node.stopActionByTag(9999);
            }

            this._isHiding = false;

            this.node.emit("fade-in");

            if (this._isHide) {
                this.node.on("backpress", this._backCallback, this);
            }

            // FocusManager.getInstance().addFocusRoot(this.node.name);
            // FocusManager.getInstance().switchFocusRoot(this.node.name);
            // FocusManager.getInstance().autoRegisterWidgetBy(this.node);

            // 设置默认焦点
            // if(this._defaultFocusNode !== "")
            // {
            //     FocusManager.getInstance().setDefaultWidget(this.node.name, this._defaultFocusNode);
            // }

            this._showAddZIndex = Date.now()%100000000;
            this.node.zIndex = this.node.zIndex + this._showAddZIndex;
        }
        this._isShowCalled = true;

    },

    isShowing : function () {
      return this.node.active && !this._isHiding;
    },

    /**
     * 设置默认焦点对象路径，在show之前调用有效，例如: bg/btnYes
     * @param defaultFocusPath
     */
    setDefaultFocus : function (defaultFocusPath) {
        this._defaultFocusNode = defaultFocusPath;
    },

    /**
     * 设置是否在按返回键时关闭弹窗
     * @param isOnBackPressedHide，默认值：true
     */
    setOnBackPressedHide : function(isOnBackPressedHide)
    {
        this._isHide = isOnBackPressedHide;
    },
    //abstract method
    init: function () {
    }
});
