let qView = require('./qview');

cc.Class({
    extends: cc.Component,
    properties:{
        questionView: qView,
    },

    ctor(){
        this.questions = [];
        this._lastIndex = null;
        this.activeQuestions = [];
    },

    onLoad(){
        cc.loader.loadResDir("questions", cc.SpriteFrame, (err, asset)=>{
            if (!err){
                this.questions = asset;
                this.init();
            }
        })
    },

    init(){
        this.restart();
    },

    restart(){
        this.activeQuestions = [...this.questions];
        this.questionView.showFinish(false);
        this.nextQuestion();
    },

    //随机去除一个题目, 并且显示
    randomQuestion(){
        if (!this.activeQuestions.length) return false;
        let index = Math.random() * this.activeQuestions.length >> 0;
        let qf = this.activeQuestions.splice(index,1 )[0];
        this.questionView.setQuestion(qf);
        return true;
    },

    nextQuestion(){
        if (!this.randomQuestion()){
            this.questionView.showFinish(true);
        }
        this.questionView.setCount(this.questions.length - this.activeQuestions.length, this.questions.length);
    },

    //点击下一个题目按钮回调
    onNextQuestion(){
        this.nextQuestion();
    },

    onRestart(){
        this.restart();
    },

});