//
//  ZipData.cpp
//
//

#include "ZipData.h"

ZipData::ZipData()
:_zipFile(nullptr)
{
    
}

ZipData::~ZipData() {
    CC_SAFE_DELETE(_zipFile);
}

void ZipData::load(const std::string& filePath) {
    auto fileUtile = FileUtils::getInstance();
    
    auto _filePath = fileUtile->fullPathForFilename(filePath);
    _data = fileUtile->getDataFromFile(_filePath);
    
    _zipFile = ZipFile::createWithBuffer(_data.getBytes(), _data.getSize());
}

unsigned char* ZipData::getFileData(const std::string& fileName, ssize_t *size) {
    return _zipFile->getFileData(fileName, size);
}
