//
//  jsb_ZipData_manual.cpp
//

#include "jsb_ZipData_manual.hpp"
#include "scripting/js-bindings/manual/cocos2d_specifics.hpp"

#include "ZipData.h"

JSClass  *jsb_SunMoon_ZipData_class;
JSObject *jsb_SunMoon_ZipData_prototype;

void js_register_SunMoon_ZipData(JSContext *cx, JS::HandleObject global) {
    jsb_SunMoon_ZipData_class = (JSClass *)calloc(1, sizeof(JSClass));
    jsb_SunMoon_ZipData_class->name = "ZipData";
    jsb_SunMoon_ZipData_class->addProperty = JS_PropertyStub;
    jsb_SunMoon_ZipData_class->delProperty = JS_DeletePropertyStub;
    jsb_SunMoon_ZipData_class->getProperty = JS_PropertyStub;
    jsb_SunMoon_ZipData_class->setProperty = JS_StrictPropertyStub;
    jsb_SunMoon_ZipData_class->enumerate = JS_EnumerateStub;
    jsb_SunMoon_ZipData_class->resolve = JS_ResolveStub;
    jsb_SunMoon_ZipData_class->convert = JS_ConvertStub;
    jsb_SunMoon_ZipData_class->finalize = js_SunMoon_ZipData_finalize;
    jsb_SunMoon_ZipData_class->flags = JSCLASS_HAS_RESERVED_SLOTS(2);
    
    static JSPropertySpec properties[] = {
        JS_PS_END
    };
    
    static JSFunctionSpec funcs[] = {
        JS_FN("load", js_SunMoon_ZipData_load, 1, JSPROP_PERMANENT | JSPROP_ENUMERATE),
        JS_FN("getFileData", js_SunMoon_ZipData_getFileData, 1, JSPROP_PERMANENT | JSPROP_ENUMERATE),
        JS_FS_END
    };
    
    JSFunctionSpec *st_funcs = NULL;
    
    
    jsb_SunMoon_ZipData_prototype = JS_InitClass(
                                                    cx, global,
                                                    JS::NullPtr(),
                                                    jsb_SunMoon_ZipData_class,
                                                    js_SunMoon_ZipData_constructor, 0, // constructor
                                                    properties,
                                                    funcs,
                                                    NULL, // no static properties
                                                    st_funcs);
    
    JS::RootedObject proto(cx, jsb_SunMoon_ZipData_prototype);
    JS::RootedValue className(cx, std_string_to_jsval(cx, "ZipData"));
    JS_SetProperty(cx, proto, "_className", className);
    JS_SetProperty(cx, proto, "__nativeObj", JS::TrueHandleValue);
    JS_SetProperty(cx, proto, "__is_ref", JS::FalseHandleValue);
    // add the proto and JSClass to the type->js info hash table
    jsb_register_class<ZipData>(cx, jsb_SunMoon_ZipData_class, proto, JS::NullPtr());
}

void js_SunMoon_ZipData_finalize(JSFreeOp *fop, JSObject *obj) {
    CCLOGINFO("jsbindings: finalizing JS object %p (ZipData)", obj);
    js_proxy_t* nproxy;
    js_proxy_t* jsproxy;
    JSContext *cx = ScriptingCore::getInstance()->getGlobalContext();
    JS::RootedObject jsobj(cx, obj);
    jsproxy = jsb_get_js_proxy(jsobj);
    if (jsproxy) {
        ZipData *nobj = static_cast<ZipData *>(jsproxy->ptr);
        nproxy = jsb_get_native_proxy(jsproxy->ptr);
        
        if (nobj) {
            jsb_remove_proxy(nproxy, jsproxy);
            JS::RootedValue flagValue(cx);
            JS_GetProperty(cx, jsobj, "__cppCreated", &flagValue);
            if (flagValue.isNullOrUndefined()){
                delete nobj;
            }
        }
        else
        jsb_remove_proxy(nullptr, jsproxy);
    }
}

bool js_SunMoon_ZipData_constructor(JSContext *cx, uint32_t argc, jsval *vp) {
    JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
    bool ok = true;
    
    ZipData* cobj = new (std::nothrow) ZipData();
    
    js_type_class_t *typeClass = js_get_type_from_native<ZipData>(cobj);
    
    JS::RootedObject jsobj(cx, jsb_create_weak_jsobject(cx, cobj, typeClass, "sunmoon::ZipData"));
    args.rval().set(OBJECT_TO_JSVAL(jsobj));
    if (JS_HasProperty(cx, jsobj, "_ctor", &ok) && ok)
    ScriptingCore::getInstance()->executeFunctionWithOwner(OBJECT_TO_JSVAL(jsobj), "_ctor", args);
    return true;
}

bool js_SunMoon_ZipData_load(JSContext *cx, uint32_t argc, jsval *vp) {
    JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
    bool ok = true;
    JS::RootedObject obj(cx, args.thisv().toObjectOrNull());
    js_proxy_t *proxy = jsb_get_js_proxy(obj);
    ZipData* cobj = (ZipData *)(proxy ? proxy->ptr : NULL);
    JSB_PRECONDITION2( cobj, cx, false, "js_SunMoon_ZipData_load : Invalid Native Object");
    
    if (argc == 1) {
        std::string arg0;
        do {
            ok &= jsval_to_std_string(cx, args.get(0), &arg0);
            if (!ok) {ok = false; break;}
        } while (0);
        
        JSB_PRECONDITION2(ok, cx, false, "js_SunMoon_ZipData_load : Error processing arguments");
        
        cobj->load(arg0);
        args.rval().setUndefined();
        return true;
    }
    
    JS_ReportError(cx, "js_SunMoon_ZipData_load : wrong number of arguments");
    return false;
}

bool js_SunMoon_ZipData_getFileData(JSContext *cx, uint32_t argc, jsval *vp) {
    
    JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
    bool ok = true;
    JS::RootedObject obj(cx, args.thisv().toObjectOrNull());
    js_proxy_t *proxy = jsb_get_js_proxy(obj);
    ZipData* cobj = (ZipData *)(proxy ? proxy->ptr : NULL);
    JSB_PRECONDITION2( cobj, cx, false, "js_SunMoon_ZipData_load : Invalid Native Object");
    
    if (argc == 1) {
        std::string arg0;
        do {
            ok &= jsval_to_std_string(cx, args.get(0), &arg0);
            if (!ok) {ok = false; break;}
        } while (0);
        
        JSB_PRECONDITION2(ok, cx, false, "js_SunMoon_ZipData_load : Error processing arguments");
        
        ssize_t strsize;
        unsigned char* data = cobj->getFileData(arg0, &strsize);
        
        if (strsize == 0) {
            args.rval().setNull();
        } else {
            jsval jsret = JSVAL_NULL;
            jsret = c_string_to_jsval(cx, (char*)data, strsize);
            args.rval().set(jsret);
        }
        return true;
    }
    
    JS_ReportError(cx, "js_SunMoon_ZipData_load : wrong number of arguments");
    return false;
}


void JSB_register_ZipData(JSContext* cx, JS::HandleObject obj) {
    JS::RootedObject ns(cx);
    get_or_create_js_obj(cx, obj, "sunmoon", &ns);
    
    js_register_SunMoon_ZipData(cx, ns);
}
