var ZipData = cc.Class({

    ctor: function () {
        this._data = {};
    },

    load: function (data) {
        this._data = data;
    },

    getFileData: function (fileName) {
        var data = this._data[fileName];
        if (data) return data;
        return null;
    }

});


module.exports = {
    RegisterZipLoader: function () {
        cc.loader.addDownloadHandlers({
            "zip": function (item, callback) {
                var obj;

                if (cc.sys.isNative) {
                    obj = new sunmoon.ZipData();
                    obj.load(item.url);
                    callback(null, obj);
                } else {
                    ZipLib(item.url, function(data){
                        obj = new ZipData();
                        obj.load(data);

                        callback(null, obj);
                    });
                }
            }
        });

        cc.loader.addLoadHandlers({
            "zip": function (item, callback) {
                callback(null, item.content);
            }
        });
    }
};