// import { autorun } from 'mobx';
// import loadMgr from '../LoadingScene/load-mgr';
import store from '../data/store';
import gameSocket from '../net/gameSocket';

const { ccclass, property } = cc._decorator;
@ccclass
class HallScene extends cc.Component {
  @property(cc.Node) content = null; // 页面存放节点
  @property(cc.Prefab) hallPagePrefab = null; // 大厅页
  hallPageNode = null;
  @property(cc.Prefab) singleGamePagePrefab = null; // 单人游戏页
  singleGamePageNode = null;
  // @property(cc.Prefab) gamePage = null; // 多人游戏页
  @property(cc.Prefab) loadingPrefab = null; // 加载页
  loadingNode = null;
  @property(cc.Prefab) alertPrefab = null; // 警告弹框
  alertNode = null;

  onLoad() {
    console.log('场景修改指向');
    cc.SingleGamePage.initScene(this);
    const wheight = cc.winSize.height; // 窗口
    const dheight = 1280; // 定义高度
    store.winScale = wheight / dheight;
  }
  start() {
    // cc.audioCom.playMusic('BGM');
    store.curScene = 'Hall';
    this.initPage();
    wx.hideShareMenu();
    // 链接ws
    this.connectWs();
    // 注册监听
    gameSocket.register();
  }
  // 关闭ws
  closeWs = () => {
    console.log('关闭ws');
    gameSocket.closeWs();
  }
  // 链接ws
  connectWs = () => {
    this.closeWs();
    console.log('链接ws');
    gameSocket.connectWs(this.connectSuc);
  }
  // 链接成功
  connectSuc = () => {
    console.log('链接成功');
    this.refreshLoadingPage(false);
    this.unschedule(this.connectWs);
    // 是否重连
    if (this.isReconnect) {
      gameSocket.sendReconnect();
      this.isReconnect = false;
    }
    // 开启定时检测链接
    this.schedule(this.checkConnect, 2);
  }
  // 定时检测链接
  checkConnect = () => {
    if (!gameSocket.isGameConnected()) {
      console.log('ws链接断开');
      this.isReconnect = true;
      this.refreshLoadingPage(true);
      this.closeWs();
      this.schedule(this.connectWs, 2);
      this.unschedule(this.checkConnect);
    }
  }

  // 添加页面
  initPage = () => {
    this.hallPageNode = cc.uts.addNode(this.hallPagePrefab, this.content);
    this.hallPageNode.scene = this;
    this.singleGamePageNode = cc.uts.addNode(this.singleGamePagePrefab, this.content);
    this.singleGamePageNode.scene = this;
    this.loadingNode = cc.uts.addNode(this.loadingPrefab, this.content);
    this.loadingNode.scene = this;
    this.alertNode = cc.uts.addNode(this.alertPrefab, this.content);
    this.alertNode.scene = this;
  }

  // 大厅页显示/隐藏
  refreshHallPage = (bool) => {
    console.log('大厅页显示/隐藏', bool);
    this.hallPageNode.active = bool;
  }
  // 游戏页显示/隐藏
  refreshSingleGamePage = (bool) => {
    console.log('游戏页显示/隐藏', bool);
    this.singleGamePageNode.active = bool;
  }
  // 加载页显示/隐藏
  refreshLoadingPage = (bool) => {
    console.log('加载页显示/隐藏', bool);
    this.loadingNode.active = bool;
  }
  // 展示警告框
  showAlert = (str, cb) => {
    this.alertNode.getComponent('Alert').show(str, cb);
  }
  onDestroy() {
    this.unBindClick();
  }
}

export default HallScene;
