

export class GameSocket extends Object{
    private _socket : WebSocket = null;
    constructor(){

        super()
    }    

    connect(host : string){

        if (this._socket){
            this._socket.close()
            this._socket = null;
        }

        this._socket = new WebSocket(host)
        this._socket.binaryType = "arraybuffer"
        
        this._socket.onopen = function (ev : Event) {
            console.log("Socket 链接成功")
        }


        this._socket.onmessage = function(ev:MessageEvent){
            console.log("onmessage ")
            let buffer : ArrayBuffer = null
            buffer = ev.data;
            
            Sproto.SprotoCore.Dispatch(ev.data)
            console.log("buffer.byteLength; :" , buffer.byteLength)
        }

        this._socket.onclose = function(ev:CloseEvent){
            console.log("socket close")
            
            console.log(ev)
        }

        this._socket.onerror = function(ev:Event){
            console.log("socket on error",ev)
        }
    }






}