"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var GameSocket = /** @class */ (function (_super) {
    __extends(GameSocket, _super);
    function GameSocket() {
        var _this = _super.call(this) || this;
        _this._socket = null;
        return _this;
    }
    GameSocket.prototype.connect = function (host) {
        if (this._socket) {
            this._socket.close();
            this._socket = null;
        }
        this._socket = new WebSocket(host);
        this._socket.binaryType = "arraybuffer";
        this._socket.onopen = function (ev) {
            console.log("Socket 链接成功");
        };
        this._socket.onmessage = function (ev) {
            console.log("onmessage ");
            var buffer = null;
            buffer = ev.data;
            Sproto.SprotoCore.Dispatch(ev.data);
            console.log("buffer.byteLength; :", buffer.byteLength);
        };
        this._socket.onclose = function (ev) {
            console.log("socket close");
            console.log(ev);
        };
        this._socket.onerror = function (ev) {
            console.log("socket on error", ev);
        };
    };
    return GameSocket;
}(Object));
exports.GameSocket = GameSocket;
