var Sproto;
(function (Sproto) {
    var SprotoReceiver = /** @class */ (function () {
        function SprotoReceiver() {
        }
        SprotoReceiver.Init = function (protocol) {
            SprotoReceiver.m_RpcReqHandlerDict = [];
            SprotoReceiver.mProtocol = protocol;
        };
        SprotoReceiver.AddHandler = function (tag, rpc, thisObj) {
            if (!rpc) {
                return;
            }
            SprotoReceiver.m_RpcReqHandlerDict[tag] = thisObj ? rpc.bind(thisObj) : rpc;
        };
        SprotoReceiver.HandlerType = function (tag, session, data, offset) {
            var func = SprotoReceiver.m_RpcReqHandlerDict[tag];
            if (func == null) {
                cc.log("无法处理消息", tag);
                return null;
            }
            if (this.sprotoLogNo.indexOf(tag) != -1)
                cc.log("S2C:" + tag);
            var rpcRsp = func(SprotoReceiver.mProtocol.GenRequest(tag, data, offset));
            if (session != null) {
                return rpcRsp;
            }
            return null;
        };
        SprotoReceiver.sprotoLogNo = [];
        return SprotoReceiver;
    }());
    Sproto.SprotoReceiver = SprotoReceiver;
})(Sproto || (Sproto = {}));
