var Sproto;
(function (Sproto) {
    var SprotoSender = /** @class */ (function () {
        function SprotoSender() {
        }
        SprotoSender.Init = function (protocol) {
            SprotoSender.m_Session = 0;
            SprotoSender.m_RpcRspHandlerDict = [];
            SprotoSender.m_SessionDict = [];
            SprotoSender.m_SendPack = new Sproto.SprotoPack();
            SprotoSender.m_SendStream = new Sproto.SprotoStream();
            SprotoSender.m_Protocol = protocol;
        };
        SprotoSender.Pack = function (tag, rpcReq, rpcRspHandler, thisObj) {
            if (rpcReq === void 0) { rpcReq = null; }
            if (rpcRspHandler === void 0) { rpcRspHandler = null; }
            if (thisObj === void 0) { thisObj = null; }
            if (rpcRspHandler != null) {
                var session = ++SprotoSender.m_Session;
                SprotoSender.m_RpcRspHandlerDict[session] = thisObj && rpcRspHandler.bind(thisObj) || rpcRspHandler;
                SprotoSender.m_SessionDict[session] = SprotoSender.m_Protocol.Get(tag).ResponseType;
                return SprotoSender.SendData(rpcReq, session, tag);
            }
            else {
                return SprotoSender.SendData(rpcReq, null, tag);
            }
        };
        SprotoSender.SendData = function (rpc, session, tag) {
            if (this.sprotoLogNo.indexOf(tag) != -1)
                cc.log("C2S:" + tag);
            var pkg = new Sproto.Spackage();
            pkg.type = tag;
            if (session != null) {
                pkg.session = session;
            }
            var stream = SprotoSender.m_SendStream;
            stream.Seek(0, Sproto.SeekOrigin.Begin);
            var len = pkg.EncodeStream(stream);
            if (rpc != null) {
                len += rpc.EncodeStream(stream);
            }
            var data = SprotoSender.m_SendPack.Pack(stream.Buffer, len);
            if (data.length > SprotoSender.MAX_PACK_LEN) {
                console.log("data.Length > " + SprotoSender.MAX_PACK_LEN + " => " + data.length);
                return null;
            }
            // stream.Seek(0, SeekOrigin.Begin);
            // stream.WriteByte(data.length >> 8);
            // stream.WriteByte(data.length);
            // stream.Write(data, 0, data.length);
            // let array = []
            // for (let i = 0; i < data.length;　++i) {
            // 	array.push(data[i])
            // }
            // console.log(array.join(" "))
            return new egret.ByteArray(data.buffer);
        };
        SprotoSender.HandlerSession = function (session, data, offset) {
            var responseType = SprotoSender.m_SessionDict[session];
            var responseFunc = SprotoSender.m_RpcRspHandlerDict[session];
            if (responseType && responseFunc) {
                var obj = new responseType();
                obj.InitArray(data, offset);
                responseFunc(obj);
            }
            else {
                console.warn("SprotoSender.Handler not found => " + session);
            }
            SprotoSender.m_SessionDict[session] = null;
            SprotoSender.m_RpcRspHandlerDict[session] = null;
        };
        SprotoSender.MAX_PACK_LEN = (1 << 16) - 1;
        SprotoSender.sprotoLogNo = []; //301,109,110,111,303,104,113,199
        return SprotoSender;
    }());
    Sproto.SprotoSender = SprotoSender;
})(Sproto || (Sproto = {}));
