var Sproto;
(function (Sproto) {
    var SprotoTypeBase = /** @class */ (function () {
        function SprotoTypeBase(max_field_count, buffer) {
            if (buffer === void 0) { buffer = null; }
            this.se = new Sproto.SprotoTypeSerialize(max_field_count);
            if (buffer != null) {
                this.de = Sproto.SprotoTypeDeserialize.CreateByArray(buffer);
                this.Decode();
            }
            else {
                this.de = Sproto.SprotoTypeDeserialize.Create();
            }
        }
        SprotoTypeBase.prototype.InitReader = function (reader) {
            this.Clear();
            this.de.InitReader(reader);
            this.Decode();
            return this.de.Size();
        };
        SprotoTypeBase.prototype.InitArray = function (buffer, offset) {
            if (offset === void 0) { offset = 0; }
            this.Clear();
            this.de.InitArray(buffer, offset);
            this.Decode();
            return this.de.Size();
        };
        SprotoTypeBase.prototype.Encode = function () {
            var stream = new Sproto.SprotoStream();
            this.EncodeStream(stream);
            var len = stream.Position;
            var buffer = new Uint8Array(len);
            stream.Seek(0, Sproto.SeekOrigin.Begin);
            stream.Read(buffer, 0, len);
            return buffer;
        };
        SprotoTypeBase.prototype.Clear = function () {
            this.de.Clear();
        };
        return SprotoTypeBase;
    }());
    Sproto.SprotoTypeBase = SprotoTypeBase;
})(Sproto || (Sproto = {}));
