var Sproto;
(function (Sproto) {
    var SprotoTypeDeserialize = /** @class */ (function () {
        function SprotoTypeDeserialize() {
            this.tag = -1;
            // this.m_DataView = new DataView(new ArrayBuffer(8));
        }
        SprotoTypeDeserialize.Create = function () {
            return new SprotoTypeDeserialize();
        };
        SprotoTypeDeserialize.CreateByArray = function (data) {
            var obj = new SprotoTypeDeserialize();
            obj.InitArray(data);
            return obj;
        };
        SprotoTypeDeserialize.CreateByReader = function (reader) {
            var obj = new SprotoTypeDeserialize();
            obj.InitReader(reader);
            return obj;
        };
        SprotoTypeDeserialize.prototype.InitArray = function (data, offset) {
            if (offset === void 0) { offset = 0; }
            this.Clear();
            this.reader = Sproto.SprotoTypeReader.CreateByArg(data, offset, data.length);
            this._DoInit();
        };
        SprotoTypeDeserialize.prototype.InitReader = function (reader) {
            this.Clear();
            this.reader = reader;
            this._DoInit();
        };
        SprotoTypeDeserialize.prototype._DoInit = function () {
            this.fn = this._ReadWord();
            var header_length = Sproto.SprotoTypeSize.SIZEOF_HEADER + this.fn * Sproto.SprotoTypeSize.SIZEOF_FIELD;
            this.begin_data_pos = header_length;
            this.cur_field_pos = this.reader.Position;
            if (this.reader.Length < header_length) {
                Sproto.SprotoTypeSize.error("invalid decode header.");
            }
            this.reader.Seek(this.begin_data_pos);
        };
        SprotoTypeDeserialize.prototype._Expand64 = function (v) {
            var value = v;
            if ((value & 0x80000000) != 0) {
                value |= (0xffffffff00000000);
            }
            return value;
        };
        SprotoTypeDeserialize.prototype._ReadWord = function () {
            var v1 = this.reader.ReadByte();
            var v2 = this.reader.ReadByte();
            // this.m_DataView.setUint8(1, v1)
            // this.m_DataView.setUint8(0, v2)
            // let reader = this.reader as any
            // reader.pos = reader.pos - 2
            // return this.m_DataView.getUint16(0)
            // return this.reader.ReadByte() |
            // 	(this.reader.ReadByte()) << 8;
            // _Log("===========ReadWord", this.m_DataView.getUint16(0), Math.pow(2, 8) * v2 + v1)
            return Math.pow(2, 8) * v2 + v1;
            // return this.m_DataView.getUint16(0)
        };
        SprotoTypeDeserialize.prototype._ReadDword = function () {
            var v1 = this.reader.ReadByte();
            var v2 = this.reader.ReadByte();
            var v3 = this.reader.ReadByte();
            var v4 = this.reader.ReadByte();
            // this.m_DataView.setUint8(3, v1)
            // this.m_DataView.setUint8(2, v2)
            // this.m_DataView.setUint8(1, v3)
            // this.m_DataView.setUint8(0, v4)
            // return this.m_DataView.getUint32(0)
            // return this.reader.ReadByte() |
            // 	(this.reader.ReadByte()) << 8 |
            // 	(this.reader.ReadByte()) << 16 |
            // 	(this.reader.ReadByte()) << 24;
            // _Log("===========Read DWord", this.m_DataView.getUint32(0), v4 * Math.pow(2, 24) + v3 * Math.pow(2, 16) + v2 * Math.pow(2, 8) + v1)
            return v4 * Math.pow(2, 24) + v3 * Math.pow(2, 16) + v2 * Math.pow(2, 8) + v1;
            // return this.m_DataView.getUint32(0)
        };
        SprotoTypeDeserialize.prototype._ReadDouble = function () {
            var v1 = this.reader.ReadByte();
            var v2 = this.reader.ReadByte();
            var v3 = this.reader.ReadByte();
            var v4 = this.reader.ReadByte();
            var v5 = this.reader.ReadByte();
            var v6 = this.reader.ReadByte();
            var v7 = this.reader.ReadByte();
            var v8 = this.reader.ReadByte();
            // this.m_DataView.setUint8(7, v1)
            // this.m_DataView.setUint8(6, v2)
            // this.m_DataView.setUint8(5, v3)
            // this.m_DataView.setUint8(4, v4)
            // this.m_DataView.setUint8(3, v5)
            // this.m_DataView.setUint8(2, v6)
            // this.m_DataView.setUint8(1, v7)
            // this.m_DataView.setUint8(0, v8)
            // return this.m_DataView.getFloat64(0)
            // var low = this._ReadDword();
            // 	var hi = this._ReadDword();
            // 	var v = low | hi << 32;
            // 	return v;
            // let v = low + hi * Math.pow(2, 32)
            // return v
            return v8 * Math.pow(2, 56) + v7 * Math.pow(2, 48) + v6 * Math.pow(2, 40) + v5 * Math.pow(2, 32) + v4 * Math.pow(2, 24) + v3 * Math.pow(2, 16) + v2 * Math.pow(2, 8) + v1;
            // _Log("===========Read Double", this.m_DataView.getFloat64(0), v)
        };
        SprotoTypeDeserialize.prototype._ReadArraySize = function () {
            if (this.value >= 0)
                Sproto.SprotoTypeSize.error("invalid array value.");
            var sz = this._ReadDword();
            if (sz < 0)
                Sproto.SprotoTypeSize.error("error array size(" + sz + ")");
            return sz;
        };
        SprotoTypeDeserialize.prototype.rt = function () {
            var pos = this.reader.Position;
            this.reader.Seek(this.cur_field_pos);
            while (this.reader.Position < this.begin_data_pos) {
                this.tag++;
                var value = this._ReadWord();
                if ((value & 1) == 0) {
                    this.cur_field_pos = this.reader.Position;
                    this.reader.Seek(pos);
                    this.value = Math.floor(value * 0.5) - 1;
                    return this.tag;
                }
                this.tag += Math.floor(value * 0.5);
            }
            this.reader.Seek(pos);
            return -1;
        };
        SprotoTypeDeserialize.prototype.ri = function () {
            if (this.value >= 0) {
                return (this.value);
            }
            else {
                var sz = this._ReadDword();
                if (sz == SprotoTypeDeserialize.sizeof_uint32) {
                    var v = this._Expand64(this._ReadDword());
                    return v;
                }
                else if (sz == SprotoTypeDeserialize.sizeof_uint64) {
                    // var low = this._ReadDword();
                    // var hi = this._ReadDword();
                    // var v = low | hi << 32;
                    // return v;
                    return this._ReadDouble();
                }
                else {
                    Sproto.SprotoTypeSize.error("read invalid integer size (" + sz + ")");
                }
            }
            return 0;
        };
        SprotoTypeDeserialize.prototype.ria = function () {
            var integer_list = null;
            var sz = this._ReadArraySize();
            if (sz == 0) {
                return [];
                // return new List<Int64>();
            }
            var len = this.reader.ReadByte();
            sz--;
            if (len == SprotoTypeDeserialize.sizeof_uint32) {
                if (sz % SprotoTypeDeserialize.sizeof_uint32 != 0) {
                    Sproto.SprotoTypeSize.error("error array size(" + sz + ")@sizeof(Uint32)");
                }
                integer_list = [];
                for (var i = 0; i < sz / SprotoTypeDeserialize.sizeof_uint32; i++) {
                    var v = this._Expand64(this._ReadDword());
                    integer_list.push(v);
                }
            }
            else if (len == SprotoTypeDeserialize.sizeof_uint64) {
                if (sz % SprotoTypeDeserialize.sizeof_uint64 != 0) {
                    Sproto.SprotoTypeSize.error("error array size(" + sz + ")@sizeof(Uint64)");
                }
                integer_list = [];
                for (var i = 0; i < sz / SprotoTypeDeserialize.sizeof_uint64; i++) {
                    // var low = this._ReadDword();
                    // var hi = this._ReadDword();
                    // var v = low | hi << 32;
                    var v_1 = this._ReadDouble();
                    integer_list.push(v_1);
                }
            }
            else {
                Sproto.SprotoTypeSize.error("error intlen(" + len + ")");
            }
            return integer_list;
        };
        SprotoTypeDeserialize.prototype.rb = function () {
            if (this.value < 0) {
                Sproto.SprotoTypeSize.error("read invalid boolean.");
                return false;
            }
            else {
                return (this.value == 0) ? (false) : (true);
            }
        };
        SprotoTypeDeserialize.prototype.rba = function () {
            var sz = this._ReadArraySize();
            var boolean_list = [];
            for (var i = 0; i < sz; i++) {
                var v = (this.reader.ReadByte() == 0) ? (false) : (true);
                boolean_list.push(v);
            }
            return boolean_list;
        };
        SprotoTypeDeserialize.prototype.rs = function () {
            var sz = this._ReadDword();
            // byte[] buffer = new byte[sz];
            var buffer = new Uint8Array(sz);
            this.reader.Read(buffer, 0, buffer.length);
            //			return System.Text.Encoding.UTF8.GetString (buffer);
            return BitUtil.decodeUTF8(buffer);
        };
        SprotoTypeDeserialize.prototype.rsa = function () {
            var sz = this._ReadArraySize();
            var stringList = [];
            for (var i = 0; sz > 0; i++) {
                if (sz < Sproto.SprotoTypeSize.SIZEOF_LENGTH) {
                    Sproto.SprotoTypeSize.error("error array size.");
                }
                var hsz = this._ReadDword();
                sz -= Sproto.SprotoTypeSize.SIZEOF_LENGTH;
                if (hsz > sz) {
                    Sproto.SprotoTypeSize.error("error array object.");
                }
                // byte[] buffer = new byte[hsz];
                var buffer = new Uint8Array(hsz);
                this.reader.Read(buffer, 0, buffer.length);
                var v = BitUtil.decodeUTF8(buffer);
                stringList.push(v);
                sz -= hsz;
            }
            return stringList;
        };
        SprotoTypeDeserialize.prototype.ro = function (cls) {
            var sz = this._ReadDword();
            var reader = Sproto.SprotoTypeReader.CreateByArg(this.reader.Buffer, this.reader.Offset, sz);
            this.reader.Seek(this.reader.Position + sz);
            var obj = new cls();
            obj.InitReader(reader);
            return obj;
        };
        SprotoTypeDeserialize.prototype._ReadElement = function (cls, reader, sz) {
            var read_size = 0;
            if (sz < Sproto.SprotoTypeSize.SIZEOF_LENGTH) {
                Sproto.SprotoTypeSize.error("error array size.");
            }
            var hsz = this._ReadDword();
            sz -= Sproto.SprotoTypeSize.SIZEOF_LENGTH;
            read_size += Sproto.SprotoTypeSize.SIZEOF_LENGTH;
            if (hsz > sz) {
                Sproto.SprotoTypeSize.error("error array object.");
            }
            reader.Init(this.reader.Buffer, this.reader.Offset, hsz);
            this.reader.Seek(this.reader.Position + hsz);
            // T obj = new T();
            // obj.init(reader);
            var obj = new cls();
            obj.InitReader(reader);
            read_size += hsz;
            return [obj, read_size];
        };
        SprotoTypeDeserialize.prototype.roa = function (cls) {
            var sz = this._ReadArraySize();
            var obj_list = [];
            var reader = Sproto.SprotoTypeReader.Create();
            for (var i = 0; sz > 0; i++) {
                var _a = this._ReadElement(cls, reader, sz), obj = _a[0], read_size = _a[1];
                obj_list.push(obj);
                sz -= read_size;
            }
            return obj_list;
        };
        SprotoTypeDeserialize.prototype.ReadMap = function (cls, func) {
            var sz = this._ReadArraySize();
            var map = {};
            var reader = Sproto.SprotoTypeReader.Create();
            for (var i = 0; sz > 0; i++) {
                var _a = this._ReadElement(cls, reader, sz), v = _a[0], read_size = _a[1];
                var k = func(v);
                map[k] = v;
                sz -= read_size;
            }
            return map;
        };
        SprotoTypeDeserialize.prototype.ReadUnknowData = function () {
            if (this.value < 0) {
                var sz = this._ReadDword();
                this.reader.Seek(sz + this.reader.Position);
            }
        };
        SprotoTypeDeserialize.prototype.Size = function () {
            return this.reader.Position;
        };
        SprotoTypeDeserialize.prototype.Clear = function () {
            this.fn = 0;
            this.tag = -1;
            this.value = 0;
            if (this.reader != null) {
                this.reader.Seek(0);
            }
        };
        SprotoTypeDeserialize.sizeof_uint64 = 8;
        SprotoTypeDeserialize.sizeof_uint32 = 4;
        return SprotoTypeDeserialize;
    }());
    Sproto.SprotoTypeDeserialize = SprotoTypeDeserialize;
})(Sproto || (Sproto = {}));
