var Sproto;
(function (Sproto) {
    var SprotoTypeFieldOP = /** @class */ (function () {
        function SprotoTypeFieldOP(max_field_count) {
            var slot_count = max_field_count / SprotoTypeFieldOP.SLOT_BITS_SIZE;
            if (max_field_count % SprotoTypeFieldOP.SLOT_BITS_SIZE > 0) {
                slot_count++;
            }
            this.HasBits = [];
            for (var i = 0; i < slot_count; ++i) {
                this.HasBits.push(0);
            }
        }
        SprotoTypeFieldOP.prototype._GetArrayIdx = function (bitIdx) {
            var size = this.HasBits.length;
            var arrayIdx = bitIdx / SprotoTypeFieldOP.SLOT_BITS_SIZE;
            return arrayIdx;
        };
        SprotoTypeFieldOP.prototype._GetSlotbitIdx = function (bitIdx) {
            var size = this.HasBits.length;
            var slotbitIdx = bitIdx % SprotoTypeFieldOP.SLOT_BITS_SIZE;
            return slotbitIdx;
        };
        SprotoTypeFieldOP.prototype.HasField = function (field_idx) {
            var array_idx = this._GetArrayIdx(field_idx);
            var slotbit_idx = this._GetSlotbitIdx(field_idx);
            var slot = this.HasBits[array_idx];
            var mask = 1 << slotbit_idx;
            return (slot & mask) != 0;
        };
        SprotoTypeFieldOP.prototype.SetField = function (field_idx, is_has) {
            var array_idx = this._GetArrayIdx(field_idx);
            var slotbit_idx = this._GetSlotbitIdx(field_idx);
            var slot = this.HasBits[array_idx];
            if (is_has) {
                var mask = (1) << slotbit_idx;
                this.HasBits[array_idx] = slot | mask;
            }
            else {
                var mask = ~((1) << slotbit_idx);
                this.HasBits[array_idx] = slot & mask;
            }
        };
        SprotoTypeFieldOP.prototype.ClearField = function () {
            for (var i = 0; i < this.HasBits.length; i++) {
                this.HasBits[i] = 0;
            }
        };
        SprotoTypeFieldOP.SLOT_BITS_SIZE = 4 * 8;
        return SprotoTypeFieldOP;
    }());
    Sproto.SprotoTypeFieldOP = SprotoTypeFieldOP;
})(Sproto || (Sproto = {}));
