var Sproto;
(function (Sproto) {
    var SprotoTypeReader = /** @class */ (function () {
        function SprotoTypeReader() {
        }
        SprotoTypeReader.Create = function () {
            return new SprotoTypeReader();
        };
        SprotoTypeReader.CreateByArg = function (buffer, offset, size) {
            var data = new SprotoTypeReader();
            data.Init(buffer, offset, size);
            return data;
        };
        Object.defineProperty(SprotoTypeReader.prototype, "Buffer", {
            get: function () {
                return this.buffer;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(SprotoTypeReader.prototype, "Position", {
            get: function () {
                return this.pos - this.begin;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(SprotoTypeReader.prototype, "Offset", {
            get: function () {
                return this.pos;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(SprotoTypeReader.prototype, "Length", {
            get: function () {
                return this.size - this.begin;
            },
            enumerable: true,
            configurable: true
        });
        SprotoTypeReader.prototype.Init = function (buffer, offset, size) {
            this.begin = offset;
            this.pos = offset;
            this.buffer = buffer;
            this.size = offset + size;
            this.check();
        };
        SprotoTypeReader.prototype.check = function () {
            if (this.pos > this.size || this.begin > this.pos) {
                Sproto.SprotoTypeSize.error("invalid pos.");
            }
        };
        SprotoTypeReader.prototype.ReadByte = function () {
            this.check();
            return this.buffer[this.pos++];
        };
        SprotoTypeReader.prototype.Seek = function (offset) {
            this.pos = this.begin + offset;
            this.check();
        };
        SprotoTypeReader.prototype.Read = function (data, offset, size) {
            var cur_pos = this.pos;
            this.pos += size;
            this.check();
            for (var i = cur_pos; i < this.pos; i++) {
                data[offset + i - cur_pos] = this.buffer[i];
            }
        };
        return SprotoTypeReader;
    }());
    Sproto.SprotoTypeReader = SprotoTypeReader;
})(Sproto || (Sproto = {}));
