var ZipFile = require("ZipFile");
cc.Class({
    extends: cc.Component,

    properties: {
        label: {
            default: null,
            type: cc.Label
        },
        // defaults, set visually when attaching this script to the Canvas
        text: 'Hello, World!'
    },

    // use this for initialization
    onLoad: function () {
        this.label.string = this.text;

        this.msg = "";
        this.datalist = [];
        this.maxLen = 15;

        this.addEvent();
    },

    showProgressEx(msgID,data) {
        var self = this;
        var str = ""
        if(msgID === "hot_update_download_start"){
            str = "开始下载";
        }
        else if (msgID === "hot_update_progress") {
            str = `正在下载...${data}%`;
        }
        else if(msgID === "hot_update_download_success"){
           
            str = "下载完成...100%";
        }
        else if(msgID === "hot_update_download_finish"){
            
            str = "全部下载完成";
        }
        else if(msgID === "hot_update_unzip_start"){
            
            str = "正在解压文件..."
        }
        else if(msgID === "hot_update_unzip_finish"){
           
            str = "解压完成！"
        }
        str += "\n";

        if(self.datalist.length >= self.maxLen){
            self.datalist.shift();
            self.datalist.push(str);
        }
        else{
            self.datalist.push(str);
        }
        var resultStr = "";
        for(var i = 0;i<self.datalist.length;++i){
            resultStr += self.datalist[i];
        }
        this.label.string = resultStr;
        
    },

    addEvent(){
        this._bindings = [
            
            notification.createBinding("hot_update_download_start",(msgID,data)=>{
                this.showProgressEx(msgID,data);
            }),
            notification.createBinding("hot_update_progress",(msgID,data)=>{
                this.showProgressEx(msgID,data);

            }),
            notification.createBinding("hot_update_download_success",(msgID,data)=>{
                this.showProgressEx(msgID,data);

            }),
            notification.createBinding("hot_update_download_finish",(msgID,data)=>{
                this.showProgressEx(msgID,data);

            }),
            notification.createBinding("hot_update_unzip_start",(msgID,data)=>{
                this.showProgressEx(msgID,data);

            }),
            notification.createBinding("hot_update_unzip_finish",(msgID,data)=>{
                this.showProgressEx(msgID,data);

                //进入游戏

                // this.finished();

            }),

        ]
    },

    start(){

        // var downUrl = "http://test-yaojiguandan-oss.oss-cn-shanghai.aliyuncs.com/hot-update/common_0.0.4.1.zip";
    
        // var dirpath = fileSystem.getLocalStorage();
        // var filepath = cc.path.join(dirpath,"common_0.0.4.1.zip");
        // this.downloader = new jsb.Downloader();
        // var self = this;
        // this.downloader.setOnTaskError(function(sender,errorCode,errorCodeInternal,errorStr){
        //     self.msg += `errorStr = ${errorStr || ""}\n`;
        //     self.label.string = self.msg;
        //     console.log(`errorStr = ${errorStr || ""}\n`);
        // })

        // this.downloader.setOnTaskProgress(function(sender,bytesReceived,totalBytesReceived,totalBytesExpected){
            
        //     var str = "下载大小 = " + bytesReceived + "," + "总大小 = " + totalBytesReceived + "," + "预期总大小 = " + totalBytesExpected + "," + "进度 = " + Math.floor(totalBytesReceived / totalBytesExpected * 10000)/100 + "%\n"
        //     if(self.datalist.length >= self.maxLen){
        //         self.datalist.shift();
        //         self.datalist.push(str);
        //     }
        //     else{
        //         self.datalist.push(str);
        //     }
        //     // self.msg += "下载大小 = " + bytesReceived + ",";
        //     // self.msg += "总大小 = " + totalBytesReceived + ",";
        //     // self.msg += "预期总大小 = " + totalBytesExpected + ",";
        //     // self.msg += "进度 = " + Math.floor(totalBytesReceived / totalBytesExpected * 10000)/100 + "%,";
        //     var resultStr = "";
        //     for(var i = 0;i<self.datalist.length;++i){
        //         resultStr += self.datalist[i];
        //     }
        //     self.label.string = resultStr;
        //     // console.log(bytesReceived,totalBytesReceived,totalBytesExpected,Math.floor(totalBytesReceived / totalBytesExpected * 10000)/100 + "%");
        // })

        // this.downloader.setOnFileTaskSuccess(function(sender){
        //     self.msg += `------------------download success\n`;
        //     // self.label.string = self.msg;

        //     var resultStr = "";
        //     for(var i = 0;i<self.datalist.length;++i){
        //         resultStr += self.datalist[i];
        //     }
        //     resultStr += `------------------download success\n`;
        //     self.label.string = resultStr;


        //     console.log(`------------------download success\n`);

        //     //unzip
        //     var dirpath = fileSystem.getLocalStorage();
        //     var filepath = cc.path.join(dirpath,"common_0.0.4.1.zip");
        //     var zipFile = new ZipFile();
        //     zipFile.init(filepath).unzip();
        // })

        // this.downloader.createDownloadFileTask(downUrl,filepath,"download_test");

        hotUpdateSystem.hotUpdate();
    },

    // called every frame
    update: function (dt) {

    },
});
