
/* 
    文件系统
*/
var fileSystem = {

    /* 
        获取本地缓存位置
    */
    getLocalStorage(){

        if(!this._storagePath){
            this._storagePath = cc.path.join((jsb.fileUtils ? jsb.fileUtils.getWritablePath() : '/'),"hot-update","/");
        }

        return this._storagePath;
    },

    /* 
        写文件到本地目录

        unit:{
            relativeFullPath:xx/xx/xxx.json, //相对于localStorage的relativeFullPath
            content:asset
        }
    */
    saveLocalStorageFile(unit){

        var relativeDirectory = cc.path.dirname(unit.relativeFullPath);
        var storageDirectory = cc.path.join(this.getLocalStorage(),relativeDirectory);
        var storagePath = cc.path.join(this.getLocalStorage(),unit.relativeFullPath);
        var byteArr = new Uint8Array(unit.content);
        if (cc.sys.isNative){
            // 存储目录
            if (jsb.fileUtils.isDirectoryExist(storageDirectory) == false) {
                jsb.fileUtils.createDirectory(storageDirectory);
            }
            // 存储文件
            if(byteArr.length > 0){
                jsb.fileUtils.writeDataToFile(byteArr, storagePath);
                cc.log(`【fileSystem】 写入文件${storagePath} 成功`);
            }
            else{
                cc.log(`【fileSystem】 写入文件${storagePath}为空!!!`);
            }
        }
    },

    /* 判断目录是否存在 */
    isDirectoryExist(dir){
        return jsb.fileUtils.isDirectoryExist(dir);
    },

    /* 创建目录 */
    createDirectory(dir){
        if (jsb.fileUtils.isDirectoryExist(dir) == false) {
            jsb.fileUtils.createDirectory(dir);
        }
    },

    getDataFromFile(fullPath){

        return jsb.fileUtils.getDataFromFile(fullPath);
    }
};

window.fileSystem = fileSystem;