/* 
    热更新逻辑支持,不做断点续传
    {
        common:{
            cur:0.0.2.0,
            dest:0.0.5.3
        },
        gd:{
            cur:0.0.2.0,
            dest:0.0.5.3
        },
        game2:{
            cur:0.0.4.0,
            dest:0.0.5.3
        }
    }
*/
var ZipFile = require("ZipFile");
var hotUpdateSystem = {
    //unzip key
    key_hot_update_unzip_flag:"key_hot_update_unzip_flag",
    //versionInfo key
    key_hot_update_versionInfo:"key_hot_update_versionInfo",

    LOCAL_STORAGE_FOLDER:"hot-update",                      // 版本资源目录

    //old md5 used
    LOCAL_STORAGE_KEY_PROJECT:"update_project_{0}",         // 本地缓存清单数据 完整manifest的json
    MODULE_PROJECT_MANIFEST_PATH:"version/{0}_project",     // 模块清单路径

    //本地记录localVersionInfo
    localVersionInfo:{},

    /* 
        判断是否需要更新
    */
    isNeedUpdate(moduleList){
        // for(var i = 0;i<moduleList.length;++i){

        // }
    },

    /* 只有common最新了 其他才能更新 否则用旧的 这个很重要*/
    _isNeedUpdate(){
        
    },

    /* 走更新，所有通过事件通知 */
    hotUpdate(){
        this._getNeedDownloadZipListAsync({common:"0.0.5.0",gd:"0.0.5.0"},["common","gd"],(zipFileList)=>{
            this._zipList = zipFileList;
            cc.log(JSON.stringify(this._zipList));
            this._downloadZipList();
        });
        
    },

    /* 获取需要更新的zip列表 
    remoteVersionInfo:远程版本信息 {common:"0.0.4.0",gd:"0.0.4.0"},ddz:{dest:"0.0.4.0"}}
    needCompareGameList:需要对比的游戏列表 ["common","gd"]
    */
    _getNeedDownloadZipListAsync(remoteVersionInfo,needCompareGameList,callback){
        this._needCompareGameList = needCompareGameList;
        //获取本地versionInfo versionInfo结构见上面
        this.getLocalVersionInfoAsync(()=>{
            cc.log("before:" + JSON.stringify(this.localVersionInfo));
            var resultList = [];
            //把目标版本写入localVersionInfo
            for(var name in remoteVersionInfo){
                if(!this.localVersionInfo[name]){
                    cc.log(`【hotUpdateSystem】 检测出更新添加新游戏 ${name}`);
                    this.localVersionInfo[name] = { dest:remoteVersionInfo[name]};
                }
                else{
                    this.localVersionInfo[name]["dest"] = remoteVersionInfo[name];
                }
            }
            cc.log("after:" + JSON.stringify(this.localVersionInfo));
            //根据本地版本和传入的需要对比的gamelist，算出需要更新版本的versionList
            for(var i = 0;i<needCompareGameList.length;++i){
                var gameName = needCompareGameList[i];
                var cur = this.localVersionInfo[gameName]["cur"];
                var dest = this.localVersionInfo[gameName]["dest"];
                resultList = resultList.concat(this._compare2getDifferVersionList(cur,dest,gameName));
            }

            //返回resultList
            callback(resultList);

        });
        
    },

    /* 比较去获取差异版本列表 */
    _compare2getDifferVersionList(ver1,ver2,gameName){
        if(!ver1){
            ver1 = "0.0.0.0";
        }
        // cc.log("ver1--------" + ver1);
        // cc.log("ver2--------" + ver2);
        var ver1Arr = ver1.split(".");
        var ver2Arr = ver2.split(".");

        var big1 = parseInt(ver1Arr[2]);
        var big2 = parseInt(ver2Arr[2]);
        var small1 = parseInt(ver1Arr[3]);
        var small2 = parseInt(ver2Arr[3]);

        //需要的结果列表
        var result = [];
        //是跨大版本
        if(big1 < big2){
            //算小版本 从0开始
            for(i = 0;i<=small2;++i){
                result.push(`${gameName}_${ver2Arr[0]}.${ver2Arr[1]}.${big2}.${i}.zip`)
            }
        }
        //非跨大版本 是小版本更新
        else{
            for(i = small1 + 1;i<=small2;++i){
                result.push(`${gameName}_${ver2Arr[0]}.${ver2Arr[1]}.${big2}.${i}.zip`)
            }
        }

        return result;
    },

    /* 是否完成所有下载任务 */
    isDownloadAllFinish(zipFileList){

    },

    /*下载zip列表 */
    _downloadZipList(){
        this._curLoadZipIndex = -1;
        cc.log(`【hotUpdateSystem】 hot_update_downloadZipList start`);

        this.timeBegin();
        this._createTempDownloadDir();
        this._initDownloader();
        this._goDownLoadNext();
    },

    /* 创建目录 */
    _createTempDownloadDir(){

        fileSystem.createDirectory(this.getZipDir_download());
    },

    /* 初始化下载器 */
    _initDownloader(){
        var self = this;
        if(!this._downloader){
            this._downloader = new jsb.Downloader();
            this._downloader.setOnTaskError(function(sender,errorCode,errorCodeInternal,errorStr){
                cc.log(`【hotUpdateSystem】downloader出错 ${errorStr || ""}\n`);
            })
    
            this._downloader.setOnTaskProgress(function(sender,bytesReceived,totalBytesReceived,totalBytesExpected){
                
                var str = "下载大小 = " + bytesReceived + "," + "总大小 = " + totalBytesReceived + "," + "预期总大小 = " + totalBytesExpected + "," + "进度 = " + Math.floor(totalBytesReceived / totalBytesExpected * 10000)/100 + "%\n"
                cc.log(`【hotUpdateSystem】 downloader进度 ${Math.floor(totalBytesReceived / totalBytesExpected * 10000)/100}`);
                notification.emit("hot_update_progress",Math.floor(totalBytesReceived / totalBytesExpected * 10000)/100);
            })
    
            this._downloader.setOnFileTaskSuccess(function(sender){
    
                cc.log(`【hotUpdateSystem】 downloader成功`);
                self._goDownLoadNext();
            })
        }
    },

    _goDownLoadNext(){
        
        this._curLoadZipIndex++;
        cc.log(this._zipList)
        if(this._curLoadZipIndex < this._zipList.length){
            var fileName = this._zipList[this._curLoadZipIndex]
            var downUrl = this.getDownZipUrl(fileName);
            var filePath = cc.path.join(this.getZipDir_download(),fileName);
            cc.log(`【hotUpdateSystem】 开始下载zip包 ${this._zipList[this._curLoadZipIndex]}`)
            this._downloader.createDownloadFileTask(downUrl,filePath,`downloadZip_${this._zipList[this._curLoadZipIndex]}`);
        }
        else{
            cc.log(`【hotUpdateSystem】 下载所有zip包完成`);
            // this.unzip(this._zipList);
            // this._updateLocalVersionInfo();
            // this.delUnUsedFiles(this._zipList);
        }
    },

    /* 解压操作 同步操作  解压下载的zip包到零时目录 */
    unzip(zipFileList){

        var downloadDir = this.getZipDir_download();
        //开始解压 设置unzip标志start
        this.setUnZiping(false);
        cc.log(`【hotUpdateSystem】 解压缩开始`);
        notification.emit("hot_update_unzip_start");
        for(var i = 0;i<zipFileList.length;++i){
            var filepath = cc.path.join(downloadDir,zipFileList[i]);
            var zipFile = new ZipFile();
            zipFile.init(filepath).unzip();
        }

        //解压完成 设置unzip标志finish  
        this.setUnZiping(true);
        cc.log(`【hotUpdateSystem】 解压缩完成`);
        notification.emit("hot_update_unzip_finish");
        this.timeEnd();

    },

    _updateLocalVersionInfo(){
        for(var i = 0;i<this._needCompareGameList.length;++i){
            var gameName = this._needCompareGameList[i];
            this.localVersionInfo[gameName]["cur"] = this.localVersionInfo[gameName]["dest"];
        }
        this.setLocalVersionInfo(this.localVersionInfo);
    },

    /* 获取存zip包的路径 */
    getZipDir_download(){
        return cc.path.join(fileSystem.getLocalStorage(),"temp-zip/");
    },

    /* 设置解压标志 */
    setUnZiping(finish){
        cmd_storage.setLocalData_Json(this.key_hot_update_unzip_flag,{finish:finish});
    },

    /* 
        是否解压完成
    */
    isUnZipFinish(){
        if(cmd_storage.hasLocalData(this.key_hot_update_unzip_flag)){
            var json = cmd_storage.getLocalData_Json(this.key_hot_update_unzip_flag);
            if(json.finish === true){
                return true;
            }
            return false;
        }
        return false; 
    },

    getDownZipUrl(zipFileName){
        return cc.path.join("http://test-yaojiguandan-oss.oss-cn-shanghai.aliyuncs.com/hot-update",zipFileName);
    },

    getLocalVersionInfoAsync(cb){
        
        //-----------------------------------HACK start------------------------------------------
            this.localVersionInfo = {
                common:{
                    cur:"0.0.4.0",
                },
                gd:{
                    cur:"0.0.4.0"
                }
            }
            cb();
            return;
            //-----------------------------------HACK end--------------------------------------------

        //缓存目录用的新版本
        if(cmd_storage.hasLocalData(this.key_hot_update_versionInfo)){
            cc.log(`【hotUpdateSystem】使用localStorage缓存的版本号`);
            this.localVersionInfo = cmd_storage.getLocalData_Json(this.key_hot_update_versionInfo);
            cb();
        }
        //没用新版本 根据老版本构造一个
        else{
            //-----------------------------------HACK start------------------------------------------
            this.localVersionInfo = {
                common:{
                    cur:"0.0.4.0",
                },
                gd:{
                    cur:"0.0.4.0"
                }
            }
            cb();
            return;
            //-----------------------------------HACK end--------------------------------------------
            var self = this;
            //加载包内目录
            cc.loader.loadResDir("version", function (error, objects,urls) { 
                // cc.log(urls);
                var data = cc.loader.getRes("version/version")
                //有version 说明是新更新机制版本
                if(data){
                    cc.log(`【hotUpdateSystem】包内 检测到version文件 说明是新更新机制版本`);
                    self.localVersionInfo = JSON.parse(data);
                    //如果是新更新机制底包则清空目录  为了保持和老版本的兼容性 做了底包判断 底包低的不删除目录

                    //暂时先不删除
                    if(false){
                        self.delHotDownloadDir();
                    }
                }
                else{
                    cc.log(`【hotUpdateSystem】包内 未检测到version文件 做一次大版本更新上去`)
                    self.localVersionInfo = {};
                }

                cb();
            })
    
        }
    },

    setLocalVersionInfo(verInfoJson){
        cmd_storage.setLocalData_Json(this.key_hot_update_versionInfo,verInfoJson);
    },

    //-------------------------------------------------------------------------------------------------------------------------------------------------------//

    /* 删除版本多余资源 为了兼容老的版本底包代码   不做删除目录暴力操作，只能比较md5值 做删除不用文件操作*/
    delUnUsedFiles(){
        notification.emit("hot_update_delUnUsedFiles_start");
        //TODO:
    },

    /* 删除所有信息 */
    delAll(){

        this.delZipDownloadDir();
        this.delHotDownloadDir();
        this.delHotVersionInfo();
    },

    /* 删除zip下载dir */
    delZipDownloadDir(){

        if(fileSystem.isDirectoryExist("temp-zip")){
            jsb.fileUtils.removeDirectory("temp-zip");
        }
    },

    /* 删除hot-update下载dir */
    delHotDownloadDir(){

        if(fileSystem.isDirectoryExist("hot-update")){
            jsb.fileUtils.removeDirectory("hot-update");
        }
    },

    /* 删除下载version信息 */
    delHotVersionInfo(){

        this.setUnZiping(false);
        this.setLocalVersionInfo(null);
    },

    timeBegin(){
        this._time = new Date().getTime();
    },

    timeEnd(){
        cc.log(`【hotUpdateSystem】 totalCost ${new Date().getTime() - this._time}/1000`);
    }
};

window.hotUpdateSystem = hotUpdateSystem;