/**
 * Created by smile on 2017/5/25.
 */
var signals = require("signals");
var notification = {
    _signals: [],

    _findSignal: function(eEvent) {
        var i, signal;

        for(i = this._signals.length; i--;) {
            signal = this._signals[i];
            if(signal.event === eEvent) {
                return signal;
            }
        }
        return null;
    },

    /**
     * 创建一个信号与监听函数的绑定
     * @param {Number} [eEvent] 事件id（也可使用字符串）。
     * @param {Function} [fnListener] 信号处理函数.
     * @param {Object} [oTarget] 信号处理函数的对象。
     * @return {Object} 返回一个描述信号与处理函数的绑定对象，作为移除绑定的句柄使用。
     */
    createBinding: function(eEvent, fnListener, oTarget) {
        // find signal
        var signal = this._findSignal(eEvent);

        // find unused signal
        if(signal === null) {
            signal = this._findSignal(null);
        }

        // create new signal
        if(signal === null) {
            signal = new signals.Signal();
            this._signals.push(signal);
        }

        // bind listener
        if(signal) {
            signal.event = eEvent;
            return signal.add(fnListener, oTarget);
        }
    },

    /**
     * 移除信号的绑定函数
     * @param {Object|Array} [oBinding] createSignalBinding返回的对象。
     */
    removeBinding: function(oBinding) {
        var bindings = oBinding instanceof Array ? oBinding : [oBinding];

        for(var i = bindings.length; i--;) {
            var one = bindings[i],
                signal = one.getSignal();

            one.detach();

            if(signal.getNumListeners() == 0) {
                signal.event = null;
            }
        }
    },

    /**
     * 发送信号
     * @param {Number} [eEvent] 事件id。
     */
    emit: function(eEvent) {
        var signal = this._findSignal(eEvent);
        if(signal) {
            signal.dispatch.apply(this, arguments);
        }
    }
};

window.notification = module.exports =  notification;


