

const MOVE_LEFT = 1;
const MOVE_RIGHT = 2;

cc.macro.ENABLE_TILEDMAP_CULLING = false;



let cf 				= require('Config');
let app 			= require('Common');
let PlatformFun 	= require('PlatformFun');

cc.Class({
    extends: cc.Component,

    properties: {
        maxSpeed: 500,
        jumps: 2,
        acceleration: 1500,
        jumpSpeed: 200,
        drag: 600,
        
        // 角色是否站立在地台上
		idStand	:	false,  
    },

    // use this for initialization
    onLoad() {
        cc.systemEvent.on(cc.SystemEvent.EventType.KEY_DOWN, this.onKeyDown, this);
        cc.systemEvent.on(cc.SystemEvent.EventType.KEY_UP, this.onKeyUp, this);

        this._moveFlags = 0;

        this._up = false;
        
        this.body = this.getComponent(cc.RigidBody);
        
//  	let getPhysicsManager = cc.director.getPhysicsManager();
//		// 开启物理步长的设置
//		getPhysicsManager.enabledAccumulator = true;
//		// 物理步长，默认 FIXED_TIME_STEP 是 1/60
//		getPhysicsManager.FIXED_TIME_STEP = 1/100;
    	
        
        
    },

    onKeyDown (event) {
        switch(event.keyCode) {
            case cc.macro.KEY.a:
       			let speed = this.body.linearVelocity;
       			speed.x	=	1000;
       			speed.y	=	500;
       			this.body.linearVelocity = speed;
                break;a
            case cc.macro.KEY.left:
                this._moveFlags |= MOVE_LEFT;
                break;
            case cc.macro.KEY.right:
                this._moveFlags |= MOVE_RIGHT;
                break;
            case cc.macro.KEY.up:
                if (!this._upPressed) {
                    this._up = true;
                }
                this._upPressed = true;
                break;
        }
    },

    onKeyUp (event) {
        switch(event.keyCode) {
            case cc.macro.KEY.left:
                this._moveFlags &= ~MOVE_LEFT;
                break;
            case cc.macro.KEY.right:
                this._moveFlags &= ~MOVE_RIGHT;
                break;
            case cc.macro.KEY.up:
                this._upPressed = false;
                break;
        }
    },



	// 碰撞系统回调	
    onBeginContact: function( contact, selfCollider, otherCollider ){
    	let that = this;
//  	console.log('角色碰撞' , otherCollider.node.group )
//  	that.idStand	=	true;
    	
    },

    // called every frame, uncomment this function to activate update callback
    update(dt) {
        var speed = this.body.linearVelocity;

        if(this._moveFlags === MOVE_LEFT) {
            // this.anim.play('walk');

            if(this.node.scaleX > 0) {
                this.node.scaleX *= -1;
            }

            speed.x -= this.acceleration * dt;
            if(speed.x < -this.maxSpeed) {
                speed.x = -this.maxSpeed;
            }
        } 
        else if (this._moveFlags === MOVE_RIGHT) {
            // this.anim.play('walk');

            if(this.node.scaleX < 0) {
                this.node.scaleX *= -1;
            }

            speed.x += this.acceleration * dt;
            if(speed.x > this.maxSpeed) {
                speed.x = this.maxSpeed;
            }
        }  
        else {
            if(speed.x != 0) {
                var d = this.drag * dt;
                if(Math.abs(speed.x) <= d) {
                    speed.x = 0;
                } else {
                    speed.x -= speed.x > 0 ? d : -d;
                }
            }
        }
        
        if(Math.abs(speed.y) < 1) {
            this.jumps   = 2;
        }

        if (this.jumps > 0 && this._up) {
            speed.y = this.jumpSpeed;
            this.jumps--;
        }
        
        this._up = false;
        this.body.linearVelocity = speed;
        
        
    },
});
