

const MOVE_LEFT = 1;
const MOVE_RIGHT = 2;

cc.macro.ENABLE_TILEDMAP_CULLING = false;



let cf 				= require('Config');
let app 			= require('Common');
let PlatformFun 	= require('PlatformFun');

cc.Class({
    extends: cc.Component,

    properties: {
        maxSpeed: 500,
        Speed: 10,
        jumps: 2,
        acceleration: 1500,
        jumpSpeed: 200,
        drag: 600,
        
        // 角色是否站立在地台上
		idStand	:	false,        
    },

    // use this for initialization
    onLoad() {
    	let that = this;
        cc.systemEvent.on(cc.SystemEvent.EventType.KEY_DOWN, this.onKeyDown, this);
        cc.systemEvent.on(cc.SystemEvent.EventType.KEY_UP, this.onKeyUp, this);

        this._moveFlags = 0;

        this._up = false;
        
        this.body = this.getComponent(cc.RigidBody);
        
//  	let getPhysicsManager = cc.director.getPhysicsManager();
//		// 开启物理步长的设置
//		getPhysicsManager.enabledAccumulator = true;
//		// 物理步长，默认 FIXED_TIME_STEP 是 1/60
//		getPhysicsManager.FIXED_TIME_STEP = 1/100;
    	
        
//  			that.getComponents( cc.RigidBody ).gravityScale 	= 1 ;
//  			that.getComponents( cc.RigidBody ).linearVelocity 	= cc.v2( 0 , 0 ) ;
        
    },

    onKeyDown (event) {
    	let that = this;
        switch(event.keyCode) {
            case cc.macro.KEY.left:
                this._upLeft = true;
                break;
            case cc.macro.KEY.right:
                this._upRight = true;
                break;
            case cc.macro.KEY.up:
                this._upPressed = true;
                break;
            case cc.macro.KEY.down:
                this._upDown = true;
                break;
            case cc.macro.KEY.space:
    			this.body.linearVelocity	= cc.v2( 0, -100) ;
    			console.log( this.body )
                break;
        }
    },
    
    
    

    onKeyUp (event) {
        switch(event.keyCode) {
            case cc.macro.KEY.left:
                this._upLeft = false;
                break;
            case cc.macro.KEY.right:
                this._upRight = false;
                break;
            case cc.macro.KEY.up:
                this._upPressed = false;
                break;
            case cc.macro.KEY.down:
                this._upDown = false;
                break;
        }
    },



	// 碰撞系统回调	
    onCollisionEnter: function( other, self ){
    	let that = this;
//  	console.log('接触地面' , other.node.group )
    	
    	
    	
    	switch( other.node.group ){
    		case 'floor':
//  			that.getComponents( cc.RigidBody ).gravityScale 	= 0 ;
//  			that.getComponents( cc.RigidBody ).linearVelocity 	= cc.v2( 0 , 0 ) ;

//				console.log( that.node.position )
    			this.body.linearVelocity	= cc.v2( 0, 0) ;
    			this.idStand	=	true;

//	            // 获取场景内所有碰撞体
//	        	let manager = cc.director.getPhysicsManager();
//	        	console.log( 'manager' , manager )
//          	let r1 = manager.rayCast( that.node.position , cc.v2( that.node.x , that.node.y-50 ) , cc.RayCastType.All )
//				console.log( r1 )

    			
    		break;
    	}
    	
    },
    onCollisionStay: function (other, self) {
//	    console.log('on collision stay');
    	this.idStand	=	true;
//	    this.node.y+=4
//  	this.body.linearVelocity	= cc.v2( 0, 50) ;
	},
	onCollisionExit: function (other, self) {
    	this.idStand	=	false;
//	    console.log('on collision exit');
//  	this.body.linearVelocity	= cc.v2( 0, -50) ;
	},
    



    // called every frame, uncomment this function to activate update callback
    update(dt) {
    	
    	if( this._upLeft ){
    		this.node.x	-= this.Speed	
    	}
    	if( this._upRight ){
    		this.node.x	+= this.Speed	
    	}
    	if( this._upPressed ){
    		this.node.y	+= this.Speed	
    	}
    	if( this._upDown ){
    		this.node.y -= this.Speed	
    	}
    	
    	if( !this.idStand ){
	   		this.node.y-=4
    	}
    	
    	
    },
});
