export const apiUrl = {
    gameAdsV2: '/common/game/v2/ads',
    adShit: '/statistics/ad/hit',
    adsShow: '/statistics/ad/show',
    loginLog: '/statistics/login_log',
    statUrl: '/statistics/user_behavior_log',
    shoreList: '/common/game/share_list'
};

export class ApiRequst {

    /**
     * 构造函数
     * @param baseUrl
     * @param pid
     */
    constructor(baseUrl, pid) {
        this.baseUrl = baseUrl;
        this.pid = pid
    }
    /**
     * 请求方式
     * @param api
     * @param method
     * @param data
     * @param header
     * @param callback
     */
    callApi(api,method, data,header, callback = (data) => {
    }) {

        let url = this.baseUrl + api

        try{
            switch (this.pid) {

                case 1 :  //微信

                    wx.request({
                        method: method,
                        url: url,
                        data: data,
                        header: header,
                        success(res) {
                            if (callback && typeof callback === 'function') {
                                callback(res.data);
                            }
                        },
                        error(error) {
                            console.error('error', error)
                        }
                    })
                    break;
                case 2: //淘宝
                    var formData = new URLSearchParams();
                    for (var key in data) {
                        formData.append(key + "", data[key]);
                    }
                    fetch(url,
                        { method: method,
                            headers: header,
                            body: formData,
                        })
                        .then(response => response.json())
                        .then(data => {
                            if (callback && typeof callback === 'function') {
                                callback(data);
                            }
                        }).catch((error) => {
                        console.error('error', error)
                    });
                    break;
                default:

                    console.error("未定义当前请求处理情况")




            }
        }catch(e){   //尝试以http原生请求来处理

            if(typeof XMLHttpRequest !== "undefined"){
                let xhr = new XMLHttpRequest();
                //1.发起请求
                xhr.onreadystatechange = function () {
                    if (xhr.readyState == 4){
                        if(xhr.status >= 200 && xhr.status < 400){
                            let res = xhr.responseText;
                            //处理方法
                            if (callback && typeof callback === 'function') {
                                callback(JSON.parse(res));
                            }
                        }else{
                            let res = xhr.responseText;
                            //处理方法
                            console.log("请求失败",res)
                        }
                    }

                }

                xhr.open("POST", url, true);
                xhr.setRequestHeader("Content-Type", "application/x-www-form-urlencoded;");//缺少这句，后台无法获取参数
                var formData = this.parseParams(data);

                xhr.send(formData);
            }

            console.error(e)

        }


    }
    parseParams(data={}) {     //转成url参数

        try {
            var tempArr = [];
            for (var i in data) {
                var key = encodeURIComponent(i);
                var value = encodeURIComponent(data[i]);
                tempArr.push(key + '=' + value);
            }
            return tempArr.join('&');
        } catch (err) {
            return '';
        }
    }



}


