cc.Class({
    extends: cc.Component,

    properties: {
        label: {
            default: null,
            type: cc.Label
        },
        animNode: cc.Node,
        // defaults, set visually when attaching this script to the Canvas
        text: 'Hello, World!'
    },

    // use this for initialization
    onLoad: function () {
        this.label.string = this.text;
    },

    start() {
        this.animComponent = this.animNode.getComponent(cc.Animation);
        cc.resources.loadDir('shot_goal', cc.SpriteFrame, null, (err, spriteFrames) => {
            if (!err) {
                // cc.log(spriteFrames);
                console.log(spriteFrames);
                // for(let item of spriteFrames){
                //     let rect = item.getRect();
                //     rect.x = 0;
                //     rect.y = 0;
                //     rect.width = 750;
                //     rect.height = 750;
                //     item.setRect(rect);
                // }
                let clip = cc.AnimationClip.createWithSpriteFrames(spriteFrames, 30);
                clip.name = 'shot_goal';
                clip.wrapMode = cc.WrapMode.Normal;
                clip.speed = 1.5;
                this.animComponent.addClip(clip);
                this.animComponent.play('shot_goal');
            }
        });
    },

    // called every frame
    update: function (dt) {

    },
});
