cc.Class({
    extends: cc.Component,

    properties: {
        content: cc.Label,
        dragBar: cc.Node,
        resizeBtn: cc.Node,
        cmdEditBox: cc.EditBox,
    },

    onLoad: function () {
		this.node.zIndex = 999;
        let self = this;
        
        cc.log = function (str) {
            self.content.string += 'log: ' + str + '\n';
        };
        
        cc.warn = function (str) {
            self.content.string += 'warn: ' + str + '\n';
        };
        
        cc.error = function (str) {
            self.content.string += 'error: ' + str + '\n';
        };
        
        cc.syslog = function (str) {
            self.content.string += str + '\n';
        };
        
        self.content.node.on('touchmove', function ( touch) {
            let y = touch.getPreviousLocation().y - touch.getLocationY();
            
            this.y += -y;
            if (this.y > 0 || -this.y > (this.height + this.parent.y))
                this.y += y;
        });
        
        self.dragBar.on('touchmove', function ( touch ) {
            let x = touch.getPreviousLocation().x - touch.getLocationX();
            let y = touch.getPreviousLocation().y - touch.getLocationY();
            this.parent.x += -x;
            this.parent.y += -y;
        });
        
        self.resizeBtn.on('touchmove', function ( touch ) {
            let lastPos = touch.getPreviousLocation();
            this.parent.width += touch.getLocationX() - lastPos.x;
            this.parent.height += lastPos.y - touch.getLocationY();
            self.content.node.width = this.parent.width - this.width;
        });
    },

    commandSubmit: function () {
        let content = this.cmdEditBox.string;

        if (content === '') {
            return;
        }

        cc.syslog('cmd: ' + content);
        let cmds = this.cmdEditBox.string.split(' ');

        let fun = this[cmds[0]];
        if (!fun) {
            cc.syslog('Invalid command !');
        }
        else {
            fun(this, cmds);
        }
        this.cmdEditBox.string = '';
    },

    // Command
    Help: function () {
        let cmdList = [
            '\n -- cl : Clean the screen',
            '\n -- e [script] : Execute the script',
            '\n -- q : Quit the console'
        ];
        cc.log('Command List:' + cmdList);
    },

    Cl: function (self) {
        let content = self.content;
        content.string = '';
    },

    E: function (self, cmds) {
        let script = '';
        for (let i = 1; i < cmds.length; ++i) {
            script += cmds[i] + ' ';
        }
        eval(script);
    },

    Q: function (self) {
        self.node.destroy();
    },
});
