//
//  ViewController.m
//  testWKWebView
//
//  Created by crown on 2018/3/21.
//  Copyright © 2018年 crown. All rights reserved.
//

#import "ViewController.h"
#import <WebKit/WebKit.h>

@interface ViewController ()<WKNavigationDelegate>

@end

@implementation ViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view, typically from a nib.
    
    //使用UIWebVIew加载本地H5
//    [self useUIWebView];
    
    //使用WKWebView加载本地h5
    [self useWKWebView];

}

//使用WKWebView加载本地h5
-(void)useWKWebView {
    WKWebView *webView = [[WKWebView alloc] initWithFrame:self.view.bounds];
    webView.navigationDelegate = self;
    [self.view addSubview:webView];
    
    //加载网络url
//        [webView loadRequest:[NSURLRequest requestWithURL:[NSURL URLWithString:@"https://www.baidu.com"]]];
//    [webView loadRequest:[NSURLRequest requestWithURL:[NSURL URLWithString:@"http://10.7.38.112/iosTestWeb/web-mobile/index.html"]]];
    
    //加载本地h5
    
    //普通H5
//    NSString *accessPath = [[NSBundle mainBundle]pathForResource:@"h5" ofType:nil];
//     NSString *path = [[NSBundle mainBundle] pathForResource:@"h5/h5" ofType:@"html"];
    
    //cocos creator构建的web-mobile
    NSString *accessPath = [[NSBundle mainBundle]pathForResource:@"web-mobile" ofType:nil];
    NSString *path = [[NSBundle mainBundle] pathForResource:@"web-mobile/index" ofType:@"html"];

    NSURL *accessUrl = [NSURL fileURLWithPath:accessPath];
    NSURL *url = [NSURL fileURLWithPath:path];
    [webView loadFileURL:url allowingReadAccessToURL:accessUrl];
}

//使用UIWebVIew加载本地H5
-(void)useUIWebView {
    UIWebView *webView = [[UIWebView alloc] initWithFrame:self.view.bounds];
    [self.view addSubview:webView];
    
    //加载本地h5
    
    //普通H5
//    NSString *path = [[NSBundle mainBundle] pathForResource:@"h5/h5" ofType:@"html"];
    
    //cocos creator构建的web-mobile
    NSString *path = [[NSBundle mainBundle] pathForResource:@"web-mobile/index" ofType:@"html"];
    
    NSURL *url = [NSURL fileURLWithPath:path];
    [webView loadRequest:[NSURLRequest requestWithURL:url]];
}


#pragma mark - WKNavigationDelegate
// 页面开始加载时调用
- (void)webView:(WKWebView *)webView didStartProvisionalNavigation:(WKNavigation *)navigation{
    
}
// 当内容开始返回时调用
- (void)webView:(WKWebView *)webView didCommitNavigation:(WKNavigation *)navigation{
    
}
// 页面加载完成之后调用
- (void)webView:(WKWebView *)webView didFinishNavigation:(WKNavigation *)navigation{
    
}
// 页面加载失败时调用
- (void)webView:(WKWebView *)webView didFailProvisionalNavigation:(WKNavigation *)navigation{
    
}
// 接收到服务器跳转请求之后调用
- (void)webView:(WKWebView *)webView didReceiveServerRedirectForProvisionalNavigation:(WKNavigation *)navigation{
    
}
// 在收到响应后，决定是否跳转
- (void)webView:(WKWebView *)webView decidePolicyForNavigationResponse:(WKNavigationResponse *)navigationResponse decisionHandler:(void (^)(WKNavigationResponsePolicy))decisionHandler{
//    NSLog(@"%@",navigationResponse.response.URL.absoluteString);
    //允许跳转
    decisionHandler(WKNavigationResponsePolicyAllow);
    //不允许跳转
    //decisionHandler(WKNavigationResponsePolicyCancel);
}
// 在发送请求之前，决定是否跳转
- (void)webView:(WKWebView *)webView decidePolicyForNavigationAction:(WKNavigationAction *)navigationAction decisionHandler:(void (^)(WKNavigationActionPolicy))decisionHandler{
//    NSLog(@"%@",navigationAction.request.URL.absoluteString);
    //允许跳转
    decisionHandler(WKNavigationActionPolicyAllow);
    //不允许跳转
    //decisionHandler(WKNavigationActionPolicyCancel);
}

@end
