

import { assetManager } from "./AssetManager";

/**
 * 当前界面所引用的资源
 */
export class autoResInfo {
    url: string;
    type: typeof cc.Asset;
    assets: cc.Asset;
    refrenceComponent: any;
}

const { ccclass, property } = cc._decorator;


@ccclass

export class UIView extends cc.Component {


    /**
     * 当前UI所有动态引用的资源
     */
    private autoRes: autoResInfo[] = [];

    /**
     * 注册ui事件
     */
    public addEventListener(): void {

    }

    /**
     * 移除ui事件
     */
    public removeEventListener(): void {

    }

    /**
     * 打开ui之后的处理
     * @param fromUI 
     * @param args 
     */
    public onOpen(uiInfo: any): void {

    }

    /**
     * 当UI再次被打开时，注意该接口针对于缓存UI
     */
    public onRelive(uiInfo: any) {

    }

    /**
     * ui关闭
     */
    public onClose() {
        this.releaseAutoRes();
    }


    /**
     * 当UI组件销毁时调用
     */
    public onDestroy() {
        this.releaseAutoRes();
    }

    /**
     * 当UI组件销毁时，自动释放当前ui所引用的资源信息
     */
    public releaseAutoRes() {
        for (let index = 0; index < this.autoRes.length; index++) {
            const element = this.autoRes[index];
            assetManager.releaseResByDecRef(element.url,element.type);
        }
        this.autoRes.length = 0;
    }


    /**
     * 当UI组件加载时，自动加载当前使用的动态资源
     * @param useRes 资源url和类型 [ useKey ]
     */
    public autoReleaseRes(useRes: autoResInfo) {
        this.autoRes.push(useRes);
    }

}