"use strict";
cc._RF.push(module, '931dd779txDWKcfFI9XTDBf', 'AssetManager');
// Script/AssetManager.ts

"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.assetManager = exports.AssetManager = exports.RelaseResArgs = exports.LoadResArgs = exports.CacheRefInfo = void 0;
/**
 * 缓存的资源信息
 */
var CacheRefInfo = /** @class */ (function () {
    function CacheRefInfo() {
    }
    return CacheRefInfo;
}());
exports.CacheRefInfo = CacheRefInfo;
/**
 * 加载参数
 */
var LoadResArgs = /** @class */ (function () {
    function LoadResArgs() {
    }
    return LoadResArgs;
}());
exports.LoadResArgs = LoadResArgs;
/**
 * 释放参数
 */
var RelaseResArgs = /** @class */ (function () {
    function RelaseResArgs() {
    }
    return RelaseResArgs;
}());
exports.RelaseResArgs = RelaseResArgs;
var isChildClassOf = cc.js["isChildClassOf"];
if (!isChildClassOf)
    isChildClassOf = cc["isChildClassOf"];
var AssetManager = /** @class */ (function () {
    function AssetManager() {
        /**
         * 处理一些需要缓存起来的资源信息
         */
        this.resInfo = {};
    }
    AssetManager.getInstance = function () {
        if (!this.instance) {
            this.instance = new AssetManager();
        }
        return this.instance;
    };
    /**
     * 获取当前内存占用资源
     */
    AssetManager.prototype.getResCount = function () {
        return this.resInfo;
    };
    /**
     * 获取一个资源的缓存信息
     * @param name
     */
    AssetManager.prototype.getOrSetResCacheInfo = function (name) {
        return this.resInfo[name];
    };
    /**
     * 对加载到的一个资源进行缓存
     * @param name 资源名称
     * @param type 资源类型
     * @param obj 资源实例
     * @param use 资源被引用的标记key
     */
    AssetManager.prototype.cacheCurResRefInfo = function (name, type, obj, use) {
        var resouce = this.getOrSetResCacheInfo(name);
        if (resouce) {
            if (resouce.useKey != use) {
                //重复加载的资源，需要增加引用计数，如果一个资源只是被重复引用，则不需要增加计数
                resouce.obj.addRef();
            }
        }
        else {
            //第一次构建的资源，存储起来
            var cacheRes = new CacheRefInfo();
            cacheRes.name = name;
            cacheRes.type = type;
            cacheRes.obj = obj; //资源obj
            cacheRes.url = name;
            cacheRes.obj.addRef(); //第一次加载需要添加引用计数
            cacheRes.useKey = use;
            this.resInfo[name] = cacheRes;
        }
    };
    /**
     * 参数配置
     */
    AssetManager.prototype.getOrSetLoadResArgs = function () {
        if (arguments.length < 1) {
            console.error("doLoadResArgs Error " + arguments);
            return null;
        }
        if (arguments.length == 1 && (arguments[0] instanceof LoadResArgs)) {
            return arguments[0];
        }
        var result = new LoadResArgs();
        if (typeof arguments[0] == 'string')
            result.url = arguments[0];
        if (arguments[0] instanceof Array)
            result.urls = arguments[0];
        for (var i = 0; i < arguments.length; i++) {
            if (i == 1 && isChildClassOf(arguments[i], cc.Asset)) {
                result.type = arguments[i];
            }
            else if (i == arguments.length - 1 && typeof arguments[i] == 'string') {
                result.use = arguments[i];
            }
            else if (typeof arguments[i] == 'function') {
                if (arguments.length > i + 1 && typeof arguments[i + 1] == 'function') {
                    result.onProcess = arguments[i];
                }
                else {
                    result.onCompleted = arguments[i];
                }
            }
        }
        return result;
    };
    AssetManager.prototype.loadRes = function () {
        var _this = this;
        var loadResArgs = this.getOrSetLoadResArgs.apply(this, arguments);
        var finishCallBack = function (error, resource) {
            if (!error) {
                _this.cacheCurResRefInfo(loadResArgs.url, loadResArgs.type, resource, loadResArgs.use);
            }
            if (loadResArgs.onCompleted) {
                loadResArgs.onCompleted(error, resource);
            }
        };
        var res = this.getOrSetResCacheInfo(loadResArgs.url);
        if (res && res.obj) {
            finishCallBack(null, res.obj);
        }
        else {
            cc.resources.load(loadResArgs.url, loadResArgs.type, loadResArgs.onProcess, finishCallBack);
        }
    };
    /**
     * 通过资源的url去释放资源，注：这里会对资源进行decRef处理
     * @param url 资源的url
     * @param decRef 当资源的refCount引用计数为0之后，引擎会自动释放这个资源
     */
    AssetManager.prototype.releaseResByDecRef = function (url, type) {
        var info = this.getOrSetResCacheInfo(url);
        if (info && info.obj) {
            info.obj.decRef();
            console.log("[\u8C03\u8BD5]:\u91CA\u653E\u4E86" + url + "\u7684\u8D44\u6E90\uFF0C\u8BE5\u8D44\u6E90\u7684\u5F15\u7528\u8BA1\u6570\u4E3A\uFF1A", info.obj.refCount);
            if (info.obj.refCount == 0) {
                delete this.resInfo[url];
            }
        }
    };
    /**
     * 通过资源实例的方式释放资源，资源可以是`Prefab`、`SpriteAtlas`等
     * @param asset 资源实例
     * @param tag  release 系列接口（例如 release、releaseAsset、releaseAll）会直接释放资源，而不会进行释放检查，只有其依赖资源会进行释放检查。所以当显式调用 release 系列接口时，可以确保资源本身一定会被释放。
     */
    AssetManager.prototype.releaseResByAsset = function (asset) {
        cc.assetManager.releaseAsset(asset);
    };
    AssetManager.instance = null;
    return AssetManager;
}());
exports.AssetManager = AssetManager;
exports.assetManager = AssetManager.getInstance();

cc._RF.pop();