
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'preview-scripts/assets/Script/AssetManager.js';
                    var __require = nodeEnv ? function (request) {
                        return cc.require(request);
                    } : function (request) {
                        return __quick_compile_project__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_project__.registerModule(__filename, module);}"use strict";
cc._RF.push(module, '931dd779txDWKcfFI9XTDBf', 'AssetManager');
// Script/AssetManager.ts

"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.assetManager = exports.AssetManager = exports.RelaseResArgs = exports.LoadResArgs = exports.CacheRefInfo = void 0;
/**
 * 缓存的资源信息
 */
var CacheRefInfo = /** @class */ (function () {
    function CacheRefInfo() {
    }
    return CacheRefInfo;
}());
exports.CacheRefInfo = CacheRefInfo;
/**
 * 加载参数
 */
var LoadResArgs = /** @class */ (function () {
    function LoadResArgs() {
    }
    return LoadResArgs;
}());
exports.LoadResArgs = LoadResArgs;
/**
 * 释放参数
 */
var RelaseResArgs = /** @class */ (function () {
    function RelaseResArgs() {
    }
    return RelaseResArgs;
}());
exports.RelaseResArgs = RelaseResArgs;
var isChildClassOf = cc.js["isChildClassOf"];
if (!isChildClassOf)
    isChildClassOf = cc["isChildClassOf"];
var AssetManager = /** @class */ (function () {
    function AssetManager() {
        /**
         * 处理一些需要缓存起来的资源信息
         */
        this.resInfo = {};
    }
    AssetManager.getInstance = function () {
        if (!this.instance) {
            this.instance = new AssetManager();
        }
        return this.instance;
    };
    /**
     * 获取当前内存占用资源
     */
    AssetManager.prototype.getResCount = function () {
        return this.resInfo;
    };
    /**
     * 获取一个资源的缓存信息
     * @param name
     */
    AssetManager.prototype.getOrSetResCacheInfo = function (name) {
        return this.resInfo[name];
    };
    /**
     * 对加载到的一个资源进行缓存
     * @param name 资源名称
     * @param type 资源类型
     * @param obj 资源实例
     * @param use 资源被引用的标记key
     */
    AssetManager.prototype.cacheCurResRefInfo = function (name, type, obj, use) {
        var resouce = this.getOrSetResCacheInfo(name);
        if (resouce) {
            if (resouce.useKey != use) {
                //重复加载的资源，需要增加引用计数，如果一个资源只是被重复引用，则不需要增加计数
                resouce.obj.addRef();
            }
        }
        else {
            //第一次构建的资源，存储起来
            var cacheRes = new CacheRefInfo();
            cacheRes.name = name;
            cacheRes.type = type;
            cacheRes.obj = obj; //资源obj
            cacheRes.url = name;
            cacheRes.obj.addRef(); //第一次加载需要添加引用计数
            cacheRes.useKey = use;
            this.resInfo[name] = cacheRes;
        }
    };
    /**
     * 参数配置
     */
    AssetManager.prototype.getOrSetLoadResArgs = function () {
        if (arguments.length < 1) {
            console.error("doLoadResArgs Error " + arguments);
            return null;
        }
        if (arguments.length == 1 && (arguments[0] instanceof LoadResArgs)) {
            return arguments[0];
        }
        var result = new LoadResArgs();
        if (typeof arguments[0] == 'string')
            result.url = arguments[0];
        if (arguments[0] instanceof Array)
            result.urls = arguments[0];
        for (var i = 0; i < arguments.length; i++) {
            if (i == 1 && isChildClassOf(arguments[i], cc.Asset)) {
                result.type = arguments[i];
            }
            else if (i == arguments.length - 1 && typeof arguments[i] == 'string') {
                result.use = arguments[i];
            }
            else if (typeof arguments[i] == 'function') {
                if (arguments.length > i + 1 && typeof arguments[i + 1] == 'function') {
                    result.onProcess = arguments[i];
                }
                else {
                    result.onCompleted = arguments[i];
                }
            }
        }
        return result;
    };
    AssetManager.prototype.loadRes = function () {
        var _this = this;
        var loadResArgs = this.getOrSetLoadResArgs.apply(this, arguments);
        var finishCallBack = function (error, resource) {
            if (!error) {
                _this.cacheCurResRefInfo(loadResArgs.url, loadResArgs.type, resource, loadResArgs.use);
            }
            if (loadResArgs.onCompleted) {
                loadResArgs.onCompleted(error, resource);
            }
        };
        var res = this.getOrSetResCacheInfo(loadResArgs.url);
        if (res && res.obj) {
            finishCallBack(null, res.obj);
        }
        else {
            cc.resources.load(loadResArgs.url, loadResArgs.type, loadResArgs.onProcess, finishCallBack);
        }
    };
    /**
     * 通过资源的url去释放资源，注：这里会对资源进行decRef处理
     * @param url 资源的url
     * @param decRef 当资源的refCount引用计数为0之后，引擎会自动释放这个资源
     */
    AssetManager.prototype.releaseResByDecRef = function (url, type) {
        var info = this.getOrSetResCacheInfo(url);
        if (info && info.obj) {
            info.obj.decRef();
            console.log("[\u8C03\u8BD5]:\u91CA\u653E\u4E86" + url + "\u7684\u8D44\u6E90\uFF0C\u8BE5\u8D44\u6E90\u7684\u5F15\u7528\u8BA1\u6570\u4E3A\uFF1A", info.obj.refCount);
            if (info.obj.refCount == 0) {
                delete this.resInfo[url];
            }
        }
    };
    /**
     * 通过资源实例的方式释放资源，资源可以是`Prefab`、`SpriteAtlas`等
     * @param asset 资源实例
     * @param tag  release 系列接口（例如 release、releaseAsset、releaseAll）会直接释放资源，而不会进行释放检查，只有其依赖资源会进行释放检查。所以当显式调用 release 系列接口时，可以确保资源本身一定会被释放。
     */
    AssetManager.prototype.releaseResByAsset = function (asset) {
        cc.assetManager.releaseAsset(asset);
    };
    AssetManager.instance = null;
    return AssetManager;
}());
exports.AssetManager = AssetManager;
exports.assetManager = AssetManager.getInstance();

cc._RF.pop();
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_project__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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