
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'preview-scripts/assets/Script/UIManager.js';
                    var __require = nodeEnv ? function (request) {
                        return cc.require(request);
                    } : function (request) {
                        return __quick_compile_project__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_project__.registerModule(__filename, module);}"use strict";
cc._RF.push(module, '1f5d2TW6zRNxYnvDNKCjyas', 'UIManager');
// Script/UIManager.ts

"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.uiManager = exports.UIManager = exports.UICF = exports.uiConfig = void 0;
var AssetManager_1 = require("./AssetManager");
/**
 * ui的配置
 */
var uiConfig;
(function (uiConfig) {
    uiConfig[uiConfig["uiTest1"] = 0] = "uiTest1";
    uiConfig[uiConfig["uiTest2"] = 1] = "uiTest2";
})(uiConfig = exports.uiConfig || (exports.uiConfig = {}));
exports.UICF = (_a = {},
    _a[uiConfig.uiTest1] = { url: '/prefab/uiTest1', viewName: 'uiTest1', type: cc.Prefab, zOrder: 1, parent: 'uiRoot', isCacheRes: false },
    _a[uiConfig.uiTest2] = { url: '/prefab/uiTest1', viewName: 'uiTest1', type: cc.Prefab, zOrder: 1, parent: 'uiRoot', isCacheRes: false },
    _a);
var UIManager = /** @class */ (function () {
    function UIManager() {
        /**
         * 用于缓存ui预制件的实例，注意各ui在关闭的时候，请还原脚本内的申请的变量内存空间
         */
        this.UIStack = {};
        this._useKey = "UseKey_By_UIManager";
    }
    UIManager.getInstance = function () {
        if (!this.instance) {
            this.instance = new UIManager();
        }
        return this.instance;
    };
    /**
     * 打开ui
     */
    UIManager.prototype.open = function (uiInfo) {
        var _this = this;
        var uiArgsConf = exports.UICF[uiInfo.index];
        var viewInstance = this.getView(uiArgsConf.viewName);
        if (!viewInstance) {
            AssetManager_1.assetManager.loadRes(uiArgsConf.url, uiArgsConf.type, function (error, prefab) {
                if (!error) {
                    console.log("[\u8C03\u8BD5]:\u52A0\u8F7D\u4E86" + uiArgsConf.viewName + "\u7684\u9884\u5236\u4EF6\u8D44\u6E90", prefab);
                    var viewNode = cc.instantiate(prefab);
                    var child = cc.director.getScene().getChildByName('Canvas');
                    var viewRoot = child.getChildByName(uiArgsConf.parent);
                    viewNode.zIndex = uiArgsConf.zOrder;
                    viewRoot.addChild(viewNode);
                    _this.UIStack[uiArgsConf.viewName] = viewNode;
                    var viewClass_1 = viewNode.getComponent(uiArgsConf.viewName);
                    if (viewClass_1 && viewClass_1.onOpen) {
                        viewClass_1.onOpen(uiInfo.data);
                        viewClass_1.addEventListener();
                        uiInfo.delayCallBack && uiInfo.delayCallBack();
                    }
                }
            }, this._useKey);
        }
        else {
            var child = cc.director.getScene().getChildByName('Canvas');
            var viewRoot = child.getChildByName(uiArgsConf.parent);
            viewRoot.addChild(viewInstance);
            viewInstance.zIndex = uiArgsConf.zOrder;
            viewInstance.active = true;
            var viewClass = viewInstance.getComponent(uiArgsConf.viewName);
            if (viewClass && viewClass.onRelive) {
                viewClass.onOpen(uiInfo.data);
                viewClass.addEventListener();
                uiInfo.delayCallBack && uiInfo.delayCallBack();
            }
        }
        ;
        if (uiInfo.successCallBack) {
            uiInfo.successCallBack();
        }
        if (uiArgsConf.isQuickClose) {
            var backGround = viewInstance.getChildByName('background');
            if (!backGround) {
                backGround = new cc.Node();
                backGround.name = 'background';
                backGround.setContentSize(cc.winSize);
                viewInstance.addChild(backGround, -1);
            }
            backGround.targetOff(cc.Node.EventType.TOUCH_START);
            backGround.on(cc.Node.EventType.TOUCH_START, function (event) {
                event.stopPropagation();
                _this.close(uiInfo.index);
            }, backGround);
        }
    };
    /**
     * 预加载某些ui，适应一些情况的处理
     * @param viewName ui对应的预制件名称
     * @param this.UIStack 将ui存储在栈中，关闭时进行释放
     */
    UIManager.prototype.preloadUI = function (viewIndex, finishCallBack) {
        var _this = this;
        var uiArgsConf = exports.UICF[viewIndex];
        AssetManager_1.assetManager.loadRes(uiArgsConf.url, cc.Prefab, function (error, prefab) {
            if (!error) {
                var viewNode = cc.instantiate(prefab);
                //只有加到canvas任意节点下，脚本的生命周期函数才会被调用
                _this.UIStack[uiArgsConf.viewName] = viewNode;
                finishCallBack && finishCallBack(true);
            }
            else {
                finishCallBack && finishCallBack(false);
            }
        });
    };
    /**
     * 获取指定ui
     */
    UIManager.prototype.getView = function (viewName) {
        var viewNode = this.UIStack[viewName];
        if (viewNode) {
            return viewNode;
        }
        else {
            //debug.error("[调试]:在UIStack中找不到指定UI", viewName)
            return null;
        }
    };
    /**
     * 隐藏指定ui
     */
    UIManager.prototype.hide = function (viewIndex, flag) {
        var uiArgsConf = exports.UICF[viewIndex];
        var viewInstance = this.UIStack[uiArgsConf.viewName];
        if (viewInstance != null) {
            viewInstance.active = flag;
        }
    };
    /**
     * 根据指定的viewIndex关闭界面
     * @param viewIndex 界面的Index
     * @param tag 当调用close关闭界面的时候，需要判断isCacheRes标记，如果存在标记，则当前界面只会从主场景节点下移除，而不会`destroy`，当前界面所有引用的资源也不会被释放
     */
    UIManager.prototype.close = function (viewIndex) {
        var uiArgsConf = exports.UICF[viewIndex];
        var viewInstance = this.UIStack[uiArgsConf.viewName];
        if (!viewInstance) {
            console.error("[调试]:UI已经被释放了", uiArgsConf.viewName);
            return;
        }
        var viewClass = viewInstance.getComponent(uiArgsConf.viewName);
        if (viewClass) {
            viewClass.onClose();
            viewClass.removeEventListener();
        }
        else {
            console.error("[调试]:预制件上找不到该脚本", uiArgsConf.viewName);
        }
        if (viewInstance) {
            var child = cc.director.getScene().getChildByName('Canvas');
            var viewRoot = child.getChildByName(uiArgsConf.parent);
            viewRoot.removeChild(viewInstance);
            if (!uiArgsConf.isCacheRes) {
                viewInstance.destroy();
                AssetManager_1.assetManager.releaseResByDecRef(uiArgsConf.url);
                delete this.UIStack[uiArgsConf.viewName];
            }
        }
    };
    /**
     * 释放
     */
    UIManager.prototype.realse = function () {
        this.UIStack = null;
    };
    UIManager.instance = null;
    return UIManager;
}());
exports.UIManager = UIManager;
exports.uiManager = UIManager.getInstance();

cc._RF.pop();
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_project__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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