"use strict";
cc._RF.push(module, '1f5d2TW6zRNxYnvDNKCjyas', 'UIManager');
// Script/UIManager.ts

"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.uiManager = exports.UIManager = exports.UICF = exports.uiConfig = void 0;
var AssetManager_1 = require("./AssetManager");
/**
 * ui的配置
 */
var uiConfig;
(function (uiConfig) {
    uiConfig[uiConfig["uiTest1"] = 0] = "uiTest1";
    uiConfig[uiConfig["uiTest2"] = 1] = "uiTest2";
})(uiConfig = exports.uiConfig || (exports.uiConfig = {}));
exports.UICF = (_a = {},
    _a[uiConfig.uiTest1] = { url: '/prefab/uiTest1', viewName: 'uiTest1', type: cc.Prefab, zOrder: 1, parent: 'uiRoot', isCacheRes: false },
    _a[uiConfig.uiTest2] = { url: '/prefab/uiTest1', viewName: 'uiTest1', type: cc.Prefab, zOrder: 1, parent: 'uiRoot', isCacheRes: false },
    _a);
var UIManager = /** @class */ (function () {
    function UIManager() {
        /**
         * 用于缓存ui预制件的实例，注意各ui在关闭的时候，请还原脚本内的申请的变量内存空间
         */
        this.UIStack = {};
        this._useKey = "UseKey_By_UIManager";
    }
    UIManager.getInstance = function () {
        if (!this.instance) {
            this.instance = new UIManager();
        }
        return this.instance;
    };
    /**
     * 打开ui
     */
    UIManager.prototype.open = function (uiInfo) {
        var _this = this;
        var uiArgsConf = exports.UICF[uiInfo.index];
        var viewInstance = this.getView(uiArgsConf.viewName);
        if (!viewInstance) {
            AssetManager_1.assetManager.loadRes(uiArgsConf.url, uiArgsConf.type, function (error, prefab) {
                if (!error) {
                    console.log("[\u8C03\u8BD5]:\u52A0\u8F7D\u4E86" + uiArgsConf.viewName + "\u7684\u9884\u5236\u4EF6\u8D44\u6E90", prefab);
                    var viewNode = cc.instantiate(prefab);
                    var child = cc.director.getScene().getChildByName('Canvas');
                    var viewRoot = child.getChildByName(uiArgsConf.parent);
                    viewNode.zIndex = uiArgsConf.zOrder;
                    viewRoot.addChild(viewNode);
                    _this.UIStack[uiArgsConf.viewName] = viewNode;
                    var viewClass_1 = viewNode.getComponent(uiArgsConf.viewName);
                    if (viewClass_1 && viewClass_1.onOpen) {
                        viewClass_1.onOpen(uiInfo.data);
                        viewClass_1.addEventListener();
                        uiInfo.delayCallBack && uiInfo.delayCallBack();
                    }
                }
            }, this._useKey);
        }
        else {
            var child = cc.director.getScene().getChildByName('Canvas');
            var viewRoot = child.getChildByName(uiArgsConf.parent);
            viewRoot.addChild(viewInstance);
            viewInstance.zIndex = uiArgsConf.zOrder;
            viewInstance.active = true;
            var viewClass = viewInstance.getComponent(uiArgsConf.viewName);
            if (viewClass && viewClass.onRelive) {
                viewClass.onOpen(uiInfo.data);
                viewClass.addEventListener();
                uiInfo.delayCallBack && uiInfo.delayCallBack();
            }
        }
        ;
        if (uiInfo.successCallBack) {
            uiInfo.successCallBack();
        }
        if (uiArgsConf.isQuickClose) {
            var backGround = viewInstance.getChildByName('background');
            if (!backGround) {
                backGround = new cc.Node();
                backGround.name = 'background';
                backGround.setContentSize(cc.winSize);
                viewInstance.addChild(backGround, -1);
            }
            backGround.targetOff(cc.Node.EventType.TOUCH_START);
            backGround.on(cc.Node.EventType.TOUCH_START, function (event) {
                event.stopPropagation();
                _this.close(uiInfo.index);
            }, backGround);
        }
    };
    /**
     * 预加载某些ui，适应一些情况的处理
     * @param viewName ui对应的预制件名称
     * @param this.UIStack 将ui存储在栈中，关闭时进行释放
     */
    UIManager.prototype.preloadUI = function (viewIndex, finishCallBack) {
        var _this = this;
        var uiArgsConf = exports.UICF[viewIndex];
        AssetManager_1.assetManager.loadRes(uiArgsConf.url, cc.Prefab, function (error, prefab) {
            if (!error) {
                var viewNode = cc.instantiate(prefab);
                //只有加到canvas任意节点下，脚本的生命周期函数才会被调用
                _this.UIStack[uiArgsConf.viewName] = viewNode;
                finishCallBack && finishCallBack(true);
            }
            else {
                finishCallBack && finishCallBack(false);
            }
        });
    };
    /**
     * 获取指定ui
     */
    UIManager.prototype.getView = function (viewName) {
        var viewNode = this.UIStack[viewName];
        if (viewNode) {
            return viewNode;
        }
        else {
            //debug.error("[调试]:在UIStack中找不到指定UI", viewName)
            return null;
        }
    };
    /**
     * 隐藏指定ui
     */
    UIManager.prototype.hide = function (viewIndex, flag) {
        var uiArgsConf = exports.UICF[viewIndex];
        var viewInstance = this.UIStack[uiArgsConf.viewName];
        if (viewInstance != null) {
            viewInstance.active = flag;
        }
    };
    /**
     * 根据指定的viewIndex关闭界面
     * @param viewIndex 界面的Index
     * @param tag 当调用close关闭界面的时候，需要判断isCacheRes标记，如果存在标记，则当前界面只会从主场景节点下移除，而不会`destroy`，当前界面所有引用的资源也不会被释放
     */
    UIManager.prototype.close = function (viewIndex) {
        var uiArgsConf = exports.UICF[viewIndex];
        var viewInstance = this.UIStack[uiArgsConf.viewName];
        if (!viewInstance) {
            console.error("[调试]:UI已经被释放了", uiArgsConf.viewName);
            return;
        }
        var viewClass = viewInstance.getComponent(uiArgsConf.viewName);
        if (viewClass) {
            viewClass.onClose();
            viewClass.removeEventListener();
        }
        else {
            console.error("[调试]:预制件上找不到该脚本", uiArgsConf.viewName);
        }
        if (viewInstance) {
            var child = cc.director.getScene().getChildByName('Canvas');
            var viewRoot = child.getChildByName(uiArgsConf.parent);
            viewRoot.removeChild(viewInstance);
            if (!uiArgsConf.isCacheRes) {
                viewInstance.destroy();
                AssetManager_1.assetManager.releaseResByDecRef(uiArgsConf.url);
                delete this.UIStack[uiArgsConf.viewName];
            }
        }
    };
    /**
     * 释放
     */
    UIManager.prototype.realse = function () {
        this.UIStack = null;
    };
    UIManager.instance = null;
    return UIManager;
}());
exports.UIManager = UIManager;
exports.uiManager = UIManager.getInstance();

cc._RF.pop();