"use strict";
cc._RF.push(module, 'a8a90oRbwpExLGplSB3fWHf', 'UIView');
// Script/UIView.ts

"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.UIView = exports.autoResInfo = void 0;
var AssetManager_1 = require("./AssetManager");
/**
 * 当前界面所引用的资源
 */
var autoResInfo = /** @class */ (function () {
    function autoResInfo() {
    }
    return autoResInfo;
}());
exports.autoResInfo = autoResInfo;
var _a = cc._decorator, ccclass = _a.ccclass, property = _a.property;
var UIView = /** @class */ (function (_super) {
    __extends(UIView, _super);
    function UIView() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        /**
         * 当前UI所有动态引用的资源
         */
        _this.autoRes = [];
        return _this;
    }
    /**
     * 注册ui事件
     */
    UIView.prototype.addEventListener = function () {
    };
    /**
     * 移除ui事件
     */
    UIView.prototype.removeEventListener = function () {
    };
    /**
     * 打开ui之后的处理
     * @param fromUI
     * @param args
     */
    UIView.prototype.onOpen = function (uiInfo) {
    };
    /**
     * 当UI再次被打开时，注意该接口针对于缓存UI
     */
    UIView.prototype.onRelive = function (uiInfo) {
    };
    /**
     * ui关闭
     */
    UIView.prototype.onClose = function () {
        this.releaseAutoRes();
    };
    /**
     * 当UI组件销毁时调用
     */
    UIView.prototype.onDestroy = function () {
        this.releaseAutoRes();
    };
    /**
     * 当UI组件销毁时，自动释放当前ui所引用的资源信息
     */
    UIView.prototype.releaseAutoRes = function () {
        for (var index = 0; index < this.autoRes.length; index++) {
            var element = this.autoRes[index];
            AssetManager_1.assetManager.releaseResByDecRef(element.url, element.type);
        }
        this.autoRes.length = 0;
    };
    /**
     * 当UI组件加载时，自动加载当前使用的动态资源
     * @param useRes 资源url和类型 [ useKey ]
     */
    UIView.prototype.autoReleaseRes = function (useRes) {
        this.autoRes.push(useRes);
    };
    UIView = __decorate([
        ccclass
    ], UIView);
    return UIView;
}(cc.Component));
exports.UIView = UIView;

cc._RF.pop();