const { ccclass, property } = cc._decorator;

@ccclass
export default class ClassicBox extends cc.Component {
	@property(cc.Sprite) private colorSpr: cc.Sprite = null;
	@property(cc.Sprite) private targetSpr: cc.Sprite = null;

	public setColorSpr(frame: cc.SpriteFrame) {
		this.colorSpr.spriteFrame = frame;
	}

	public clearColorSpr() {
		this.colorSpr.spriteFrame = null;
	}

	public showTargetSpr() {
		this.targetSpr.node.active = true;
	}

	public hideTargetSpr() {
		this.targetSpr.node.active = false;
	}
}
