"use strict";
cc._RF.push(module, 'e53e6YiUd9FJLf8yIQu1n47', 'launch');
// scripts/launch.js

'use strict';

//
// api: https://developers.weixin.qq.com/minigame/dev/document/open-api/data/wx.getUserInfo.html
//
cc.Class({
    extends: cc.Component,

    properties: {
        content: cc.Node,
        prefab: cc.Prefab,
        selfNode: cc.Node,
        rankView: cc.Node
    },

    start: function start() {
        var _this = this;

        this.selfData = null;
        this.rankArray = [];
        this.itemArray = [];
        this.selfItem = null;

        //接收主域数据
        wx.onMessage(function (data) {
            _this.selfNode.active = data.state;
            _this.rankView.active = data.state;
            if (data.state) {
                _this.getFriendInfo();
            }
        });

        this.getFriendInfo();
    },


    //获取好友信息
    getFriendInfo: function getFriendInfo() {
        var _this2 = this;

        wx.getFriendCloudStorage({
            keyList: ["deep"],
            success: function success(res) {
                // console.log("initFriendInfo===111===",res);
                //排序
                res.data.sort(function (a, b) {
                    return b.KVDataList[0].value - a.KVDataList[0].value;
                });

                _this2.rankArray = [];
                for (var i = 0; i < res.data.length; ++i) {
                    var rankData = {};
                    rankData.index = i + 1;
                    rankData.nickname = res.data[i].nickname;
                    rankData.rankNum = res.data[i].KVDataList[0].value;
                    rankData.avatarUrl = res.data[i].avatarUrl;
                    rankData.isSelf = false;
                    _this2.rankArray.push(rankData);
                }
                _this2.initUserInfo(res.data);
            },
            fail: function fail(res) {
                console.error(res);
            }
        });
    },

    //获取自己信息
    initUserInfo: function initUserInfo(dataArray) {
        var _this3 = this;

        wx.getUserInfo({
            openIdList: ['selfOpenId'],
            lang: 'zh_CN',
            success: function success(res) {
                console.log("initUserInfo===111===", res.data[0]);
                var index = 0;
                for (var i = 0; i < dataArray.length; ++i) {
                    if (dataArray[i].avatarUrl == res.data[0].avatarUrl) {
                        index = i;
                    }
                }
                var randkNum = "";
                for (var i = 0; i < _this3.rankArray.length; ++i) {
                    if (_this3.rankArray[i].avatarUrl == res.data[0].avatarUrl) {
                        randkNum = _this3.rankArray[i].rankNum;
                    }
                }
                _this3.selfData = {};
                _this3.selfData.index = index + 1;
                _this3.selfData.nickname = res.data[0].nickName;
                _this3.selfData.rankNum = randkNum;
                _this3.selfData.avatarUrl = res.data[0].avatarUrl;
                _this3.selfData.isSelf = true;

                _this3.updateView();
            },
            fail: function fail(res) {
                console.error(res);
            }
        });
    },

    //更新界面
    updateView: function updateView() {
        //排行
        for (var i = 0; i < this.rankArray.length; ++i) {
            if (i < this.itemArray.length) {
                this.itemArray[i].updateInfo(this.rankArray[i]);
            } else {
                var node = cc.instantiate(this.prefab);
                node.parent = this.content;
                var item = node.getComponent("item");
                this.itemArray.push(item);
                item.updateInfo(this.rankArray[i]);
            }
        }
        //自己
        if (!this.selfItem) {
            var node = cc.instantiate(this.prefab);
            node.parent = this.selfNode;
            this.selfItem = node.getComponent("item");
        }
        this.selfItem.updateInfo(this.selfData);

        this.content.height = this.rankArray.length * 102 + 20;
    }

});

cc._RF.pop();