const JSZip = require("jszip.min");

cc.Class({
    extends: cc.Component,

    properties: {
        label: {
            default: null,
            type: cc.Label
        },
        // defaults, set visually when attaching this script to the Canvas
        text: 'Hello, World!'
    },

    // use this for initialization
    onLoad () {
        this.label.string = this.text;
    },

    btnLoadZipClick () {
        // OK
        // const url = cc.url.raw('resources/hello.zip');
        // Error
        const url = cc.url.raw('resources/hello');
        cc.loader.load({ url, type: "binary" }, (err, zipData) => {
            if (!err) {
                cc.log(`load zipData success......`);
                const newZip = new JSZip();
                newZip.loadAsync(zipData).then(zip => {
                    zip.file('hello.txt').async('string').then(data => {
                        cc.log(`解压成功！`, data);
                    });
                }).catch((e) => {
                    console.error(e);
                });
            } else {
                console.error(err);
            }
        });
    }
});
