"use strict";
cc._RF.push(module, '280c3rsZJJKnZ9RqbALVwtK', 'HelloWorld');
// Script/HelloWorld.js

"use strict";

var JSZip = require("jszip.min");

cc.Class({
  "extends": cc.Component,
  properties: {
    label: {
      "default": null,
      type: cc.Label
    },
    // defaults, set visually when attaching this script to the Canvas
    text: 'Hello, World!'
  },
  // use this for initialization
  onLoad: function onLoad() {
    this.label.string = this.text;
  },
  btnLoadZipClick: function btnLoadZipClick() {
    // OK
    // const url = cc.url.raw('resources/hello.zip');
    // Error
    var url = cc.url.raw('resources/hello');
    cc.loader.load({
      url: url,
      type: "binary"
    }, function (err, zipData) {
      if (!err) {
        cc.log("load zipData success......");
        var newZip = new JSZip();
        newZip.loadAsync(zipData).then(function (zip) {
          zip.file('hello.txt').async('string').then(function (data) {
            cc.log("\u89E3\u538B\u6210\u529F\uFF01", data);
          });
        })["catch"](function (e) {
          console.error(e);
        });
      } else {
        console.error(err);
      }
    });
  }
});

cc._RF.pop();