/**
 * 模块管理类
 */
import Utils from './Utils';

const ModuleManager = {};

ModuleManager.modules = {};

ModuleManager.add = function (name, layer, cb) {
    if (ModuleManager.modules[name]) {
        cb && cb();
        console.log("重复添加模块!");
        return;
    }
    //因为是异步的,所以事先设定给一个值,防止同一时间多次加载
    ModuleManager.modules[name] = true;
    //
    var path = 'prefab/module/' + name;
    if (!layer || layer === "low") {
        parent = cc.find("Root/LayerLow");
    } else if (layer === "middle") {
        parent = cc.find("Root/LayerMiddle");
    } else {
        parent = cc.find("Root/LayerHigh");
    }
    Utils.LoadRes(path, parent, true, (node) => {
        ModuleManager.modules[name] = node;    
        cb && cb();
    }, () => {
        ModuleManager.modules[name] = null;
    });
};

ModuleManager.remove = function (name) {
    var module = ModuleManager.modules[name];
    if (module && typeof (module) === 'object') {    
        module.destroy();
        ModuleManager.modules[name] = null;        
    }
};

ModuleManager.removeAll = function () {
    for (const key in ModuleManager.modules) {
        if (ModuleManager.modules.hasOwnProperty(key)) {
            const module = ModuleManager.modules[key];
            module.destroy();
        }
    }
    ModuleManager.modules = {};
};

export default ModuleManager;
