/**
 * Tips管理类
 */
import Com from './Com';
import Utils from './Utils';

cc.Class({
    extends: cc.Component,
    properties: {
        temp: cc.Node,
        root: cc.Node,
    },

    onLoad() {
        Com.TipsManager = this;
        this.temp.active = false;
        this.pool = [];
    },

    getFreeTips() {
        for (let i = 0, len = this.pool.length; i < len; i++) {
            if (!this.pool[i].working) {
                return this.pool[i];
            }
        }
        return null;
    },

    createNewTips() {    
        let node = Utils.Instantiate(this.temp,this.root);    
        let tips = node.getComponent("Tips");
        this.pool.push(tips);
        return tips;
    },

    show(msg) {
        let tips = this.getFreeTips();
        if (!tips) {
            tips = this.createNewTips();
        }
        tips.reset(msg);    
        console.log("Tips Count:"+this.pool.length);
    },
});