/**
 * 工具类
 */
const Utils = {};

Utils.LoadRes = function (path, parent, reset, cbsuccess, cberror) {
    if (!path || !parent) {
        cc.error('LoadRes error:' + "null params");
        return;
    }
    var onResourceLoaded = function (errorMessage, loadedResource) {
        if (errorMessage) {
            cc.error('LoadRes error:' + errorMessage);
            cberror && cberror();
            return;
        }
        if (!(loadedResource instanceof cc.Prefab)) {
            cc.error('LoadRes error');
            cberror && cberror();
            return;
        }
        var node = null;
        if(reset){
            node = Utils.Instantiate(loadedResource, parent)
        }else{
            node = Utils.InstantiateNoReset(loadedResource, parent)
        }        
        cbsuccess && cbsuccess(node);
    };
    cc.loader.loadRes(path, onResourceLoaded);
};

Utils.LoadResAry = function (pathAry, parent, reset, cbsuccess, cberror) {
    if (!pathAry || !parent) {
        cc.error('LoadRes error:' + "null params");
        return;
    }
    var onResourceLoaded = function (errorMessage, assets) {
        if (errorMessage) {
            cc.error('LoadRes error:' + errorMessage);
            cberror && cberror();
            return;
        }
        let nodes = [];    
        for (let index = 0; index < assets.length; index++) {
            const asset = assets[index];
            var node = null;
            if(reset){
                node = Utils.Instantiate(asset, parent);
            }else{
                node = Utils.InstantiateNoReset(asset, parent);
            }            
            nodes.push(node);
        }
        cbsuccess && cbsuccess(nodes);
    };
    cc.loader.loadResArray(pathAry, onResourceLoaded);
};

Utils.Instantiate = function (temp, parent) {
    let node = cc.instantiate(temp);
    parent.addChild(node);
    node.setPosition(0, 0);
    node.setScale(1);
    node.angle = 0;
    return node;
};

Utils.InstantiateNoReset = function (temp, parent) {
    let node = cc.instantiate(temp);
    parent.addChild(node);
    return node;
};

export default Utils;
